/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.element;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.AbstractECRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;
import sirttas.elementalcraft.item.ECItems;

public class ExtractionRecipeCategory
extends AbstractECRecipeCategory<ElementType> {
    public static final String NAME = "extraction";
    private final int amount;
    private final ItemStack extractor;
    protected final List<ItemStack> tanks;

    public ExtractionRecipeCategory(IGuiHelper guiHelper) {
        this(guiHelper, "elementalcraft.jei.extraction", new ItemStack((ItemLike)ECItems.EXTRACTOR), Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)ECItems.TANK), new ItemStack((ItemLike)ECItems.TANK_SMALL)}), 1);
    }

    protected ExtractionRecipeCategory(IGuiHelper guiHelper, String translationKey, ItemStack extractor, List<ItemStack> tanks, int amount) {
        super(translationKey, ExtractionRecipeCategory.createDrawableStack(guiHelper, extractor), (IDrawable)guiHelper.createBlankDrawable(64, 48));
        this.extractor = extractor;
        this.tanks = tanks;
        this.amount = amount;
        this.setOverlay((IDrawable)guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/overlay/extraction.png"), 0, 0, 45, 44), 0, 0);
    }

    @Nonnull
    public RecipeType<ElementType> getRecipeType() {
        return ECJEIRecipeTypes.EXTRACTION;
    }

    @Nonnull
    public List<Component> getTooltipStrings(@Nonnull ElementType recipe, @Nonnull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 0.0 && mouseX < 16.0 && mouseY > 0.0 && mouseY < 16.0) {
            return Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("block.elementalcraft.source." + recipe.m_7912_())});
        }
        return Collections.emptyList();
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull ElementType type, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 0, 16).addItemStack(this.extractor);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 32).addItemStacks(this.tanks);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 47, 32).addIngredient(ECIngredientTypes.ELEMENT, (Object)new IngredientElementType(type, this.amount));
    }
}

