/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Lazy;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.PureInfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.SpellCraftRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.EvaporationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ImprovedExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.SolarSynthesisRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.BindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.CrystallizationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.InscriptionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.GrindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.InfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.PurificationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientRenderer;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;
import sirttas.elementalcraft.recipe.SpellCraftRecipe;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;
import sirttas.elementalcraft.recipe.instrument.InscriptionRecipe;
import sirttas.elementalcraft.recipe.instrument.binding.AbstractBindingRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.tag.ECTags;

@JeiPlugin
public class ElementalCraftJEIPlugin
implements IModPlugin {
    private static final Lazy<HolderSet.Named<Item>> SPELL_CAST_TOOLS = Lazy.of(() -> ECTags.Items.getTag(ECTags.Items.SPELL_CAST_TOOLS));
    private static final Lazy<HolderSet.Named<Item>> JEWEL_SOCKETALBES = Lazy.of(() -> ECTags.Items.getTag(ECTags.Items.JEWEL_SOCKETABLES));
    private static final ResourceLocation ID = ElementalCraft.createRL("main");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ECIngredientTypes.ELEMENT, IngredientElementType.all(), (IIngredientHelper)new ElementIngredientHelper(), (IIngredientRenderer)new ElementIngredientRenderer());
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        registry.useNbtForSubtypes(new Item[]{ECItems.SCROLL});
        registry.useNbtForSubtypes(new Item[]{ECItems.RECEPTACLE, ECItems.RECEPTACLE_IMPROVED});
        registry.useNbtForSubtypes(new Item[]{ECItems.PURE_ORE});
        registry.useNbtForSubtypes(new Item[]{ECItems.RUNE});
        registry.useNbtForSubtypes(new Item[]{ECItems.JEWEL});
        registry.useNbtForSubtypes(new Item[]{ECItems.TANK, ECItems.TANK_SMALL, ECItems.TANK_CREATIVE});
        registry.useNbtForSubtypes(new Item[]{ECItems.FIRE_RESERVOIR, ECItems.WATER_RESERVOIR, ECItems.EARTH_RESERVOIR, ECItems.AIR_RESERVOIR});
        registry.useNbtForSubtypes(new Item[]{ECItems.FIRE_HOLDER, ECItems.WATER_HOLDER, ECItems.EARTH_HOLDER, ECItems.AIR_HOLDER, ECItems.PURE_HOLDER});
        if (!ECinteractions.isBotaniaActive()) {
            this.excludeSubtypes(registry, new ItemLike[]{ECBlocks.MANA_SYNTHESIZER, ECBlocks.MYSTICAL_GROVE_SHRINE_UPGRADE});
        }
    }

    private void excludeSubtypes(ISubtypeRegistration registry, ItemLike ... items) {
        for (ItemLike item : items) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item.m_5456_(), (i, c) -> "");
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ImprovedExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EvaporationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolarSynthesisRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrystallizationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InscriptionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PureInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PurificationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new GrindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpellCraftRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.FIRE_FURNACE), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.FIRE_BLAST_FURNACE), new RecipeType[]{RecipeTypes.BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.EXTRACTOR), new RecipeType[]{ECJEIRecipeTypes.EXTRACTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.EXTRACTOR_IMPROVED), new RecipeType[]{ECJEIRecipeTypes.EXTRACTION_IMPROVED});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.EVAPORATOR), new RecipeType[]{ECJEIRecipeTypes.EVAPORATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.SOLAR_SYNTHESIZER), new RecipeType[]{ECJEIRecipeTypes.SOLAR_SYNTHESIS});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.INFUSER), new RecipeType[]{ECJEIRecipeTypes.INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.BINDER_IMPROVED), new RecipeType[]{ECJEIRecipeTypes.INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.BINDER), new RecipeType[]{ECJEIRecipeTypes.BINDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.BINDER_IMPROVED), new RecipeType[]{ECJEIRecipeTypes.BINDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.CRYSTALLIZER), new RecipeType[]{ECJEIRecipeTypes.CRYSTALLIZATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.INSCRIBER), new RecipeType[]{ECJEIRecipeTypes.INSCRIPTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.CHISEL), new RecipeType[]{ECJEIRecipeTypes.INSCRIPTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.PURE_INFUSER), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.FIRE_PEDESTAL), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.WATER_PEDESTAL), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.EARTH_PEDESTAL), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.AIR_PEDESTAL), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.PURIFIER), new RecipeType[]{ECJEIRecipeTypes.PURIFICATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.AIR_MILL), new RecipeType[]{ECJEIRecipeTypes.GRINDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.SPELL_DESK), new RecipeType[]{ECJEIRecipeTypes.SPELL_CRAFTING});
        if (ECinteractions.isMekanismActive()) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.AIR_MILL), new ResourceLocation[]{new ResourceLocation("mekanism", "crusher")});
        }
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        registry.addRecipes(ECJEIRecipeTypes.EXTRACTION, ElementType.ALL_VALID);
        registry.addRecipes(ECJEIRecipeTypes.EXTRACTION_IMPROVED, ElementType.ALL_VALID);
        registry.addRecipes(ECJEIRecipeTypes.EVAPORATION, EvaporationRecipeCategory.getShards());
        registry.addRecipes(ECJEIRecipeTypes.SOLAR_SYNTHESIS, SolarSynthesisRecipeCategory.getLenses());
        registry.addRecipes(ECJEIRecipeTypes.INFUSION, recipeManager.m_44013_(IInfusionRecipe.TYPE));
        registry.addRecipes(ECJEIRecipeTypes.BINDING, recipeManager.m_44013_(AbstractBindingRecipe.TYPE));
        registry.addRecipes(ECJEIRecipeTypes.CRYSTALLIZATION, recipeManager.m_44013_(CrystallizationRecipe.TYPE));
        registry.addRecipes(ECJEIRecipeTypes.INSCRIPTION, recipeManager.m_44013_(InscriptionRecipe.TYPE));
        registry.addRecipes(ECJEIRecipeTypes.PURE_INFUSION, recipeManager.m_44013_(PureInfusionRecipe.TYPE));
        registry.addRecipes(ECJEIRecipeTypes.GRINDING, recipeManager.m_44013_(IGrindingRecipe.TYPE));
        registry.addRecipes(ECJEIRecipeTypes.SPELL_CRAFTING, recipeManager.m_44013_(SpellCraftRecipe.TYPE));
        registry.addRecipes(ECJEIRecipeTypes.PURIFICATION, ElementalCraft.PURE_ORE_MANAGER.getRecipes());
        registry.addRecipes(RecipeTypes.ANVIL, this.createCastToolsAnvilRecipes(registry.getVanillaRecipeFactory()));
        registry.addRecipes(RecipeTypes.ANVIL, this.createJewelsAnvilRecipes(registry.getVanillaRecipeFactory()));
    }

    private List<IJeiAnvilRecipe> createCastToolsAnvilRecipes(IVanillaRecipeFactory factory) {
        return Spells.REGISTRY.get().getValues().stream().filter(Spell::isVisible).mapMulti((spell, downstream) -> ((HolderSet.Named)SPELL_CAST_TOOLS.get()).forEach(item -> {
            ItemStack scroll = new ItemStack((ItemLike)ECItems.SCROLL);
            ItemStack stack = new ItemStack(item);
            SpellHelper.setSpell(scroll, spell);
            SpellHelper.addSpell(stack, spell);
            downstream.accept(factory.createAnvilRecipe(new ItemStack(item), List.of(scroll), List.of(stack)));
        })).toList();
    }

    private List<IJeiAnvilRecipe> createJewelsAnvilRecipes(IVanillaRecipeFactory factory) {
        return Jewels.REGISTRY.get().getValues().stream().flatMap(jewel -> ((HolderSet.Named)JEWEL_SOCKETALBES.get()).m_203614_().map(item -> {
            ItemStack jewelItem = new ItemStack((ItemLike)ECItems.JEWEL);
            ItemStack stack = new ItemStack(item);
            JewelHelper.setJewel(jewelItem, jewel);
            JewelHelper.setJewel(stack, jewel);
            return factory.createAnvilRecipe(new ItemStack(item), List.of(jewelItem), List.of(stack));
        })).toList();
    }
}

