/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.infusion.tool;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.api.infusion.tool.effect.IToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.AttributeToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.AutoSmeltToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.DodgeToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.ElementCostReductionToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.EnchantmentToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.FastDrawToolInfusionEffect;
import sirttas.elementalcraft.nbt.NBTHelper;

public class ToolInfusionHelper {
    private ToolInfusionHelper() {
    }

    public static ToolInfusion getInfusion(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        CompoundTag nbt = NBTHelper.getECTag(stack);
        if (nbt != null && nbt.m_128425_("infusion", 8)) {
            return (ToolInfusion)ElementalCraftApi.TOOL_INFUSION_MANAGER.get(new ResourceLocation(nbt.m_128461_("infusion")));
        }
        return null;
    }

    public static void setInfusion(ItemStack stack, ToolInfusion infusion) {
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag nbt = NBTHelper.getOrCreateECTag(stack);
        nbt.m_128359_("infusion", infusion.getId().toString());
    }

    public static void removeInfusion(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag nbt = NBTHelper.getECTag(stack);
        if (!stack.m_41619_() && nbt != null && nbt.m_128441_("infusion")) {
            nbt.m_128473_("infusion");
        }
    }

    public static boolean hasAutoSmelt(ItemStack stack) {
        return ToolInfusionHelper.getInfusionEffects(stack, AutoSmeltToolInfusionEffect.class).count() > 0L;
    }

    public static int getFasterDraw(ItemStack stack) {
        return ToolInfusionHelper.getInfusionEffects(stack, FastDrawToolInfusionEffect.class).findAny().map(FastDrawToolInfusionEffect::getValue).orElse(-1);
    }

    public static boolean hasFireInfusion(Entity entity) {
        return ToolInfusionHelper.getInfusions(entity).anyMatch(infusion -> infusion.getElementType() == ElementType.FIRE);
    }

    public static double getDodge(Entity entity) {
        return ToolInfusionHelper.getInfusionEffects(entity).filter(DodgeToolInfusionEffect.class::isInstance).map(DodgeToolInfusionEffect.class::cast).mapToDouble(infusion -> 1.0 - infusion.getValue()).reduce(1.0, (a, b) -> a * b);
    }

    private static Stream<ToolInfusion> getInfusions(Entity entity) {
        return StreamSupport.stream(entity.m_20158_().spliterator(), false).map(ToolInfusionHelper::getInfusion).filter(Objects::nonNull);
    }

    private static Stream<IToolInfusionEffect> getInfusionEffects(Entity entity) {
        return ToolInfusionHelper.getInfusions(entity).flatMap(t -> t.getEffects().stream());
    }

    private static <T extends IToolInfusionEffect> Stream<T> getInfusionEffects(ItemStack stack, Class<T> type) {
        ToolInfusion infusion = ToolInfusionHelper.getInfusion(stack);
        return infusion != null ? infusion.getEffects().stream().filter(type::isInstance).map(type::cast) : Stream.empty();
    }

    public static int getInfusionEnchantmentLevel(ItemStack stack, Enchantment ench) {
        return ToolInfusionHelper.getInfusionEffects(stack, EnchantmentToolInfusionEffect.class).filter(i -> i.getEnchantment() == ench).mapToInt(EnchantmentToolInfusionEffect::getLevel).sum();
    }

    public static Multimap<Attribute, AttributeModifier> getInfusionAttribute(ItemStack stack, EquipmentSlot slot) {
        ArrayListMultimap map = ArrayListMultimap.create();
        ToolInfusionHelper.getInfusionEffects(stack, AttributeToolInfusionEffect.class).filter(i -> i.getSlots().contains(slot)).forEach(arg_0 -> ToolInfusionHelper.lambda$getInfusionAttribute$6((Multimap)map, arg_0));
        return map;
    }

    public static float getElementCostReduction(Entity entity) {
        return (float)ToolInfusionHelper.getInfusionEffects(entity).filter(ElementCostReductionToolInfusionEffect.class::isInstance).map(ElementCostReductionToolInfusionEffect.class::cast).mapToDouble(infusion -> 1.0 - (double)infusion.getValue()).reduce(1.0, (a, b) -> a * b);
    }

    private static /* synthetic */ void lambda$getInfusionAttribute$6(Multimap map, AttributeToolInfusionEffect i) {
        map.put((Object)i.getAttribute(), (Object)i.getModifier());
    }
}

