/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.gui.GuiHelper;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class GuiHandler {
    private GuiHandler() {
    }

    @SubscribeEvent
    public static void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.LAYER) {
            PoseStack matrixStack = event.getMatrixStack();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Spell spell = GuiHandler.getSpell();
            int i = 0;
            for (ISingleElementStorage storage : GuiHandler.getElementStorage((Player)player)) {
                ElementType type = storage.getElementType();
                GuiHandler.doRenderElementGauge(matrixStack, storage.getElementAmount(), storage.getElementCapacity(), type, i);
                if (spell.isValid() && spell.getElementType() == type && i == 0 && GuiHandler.isPlayerOwned((Player)player, storage)) {
                    GuiHandler.doRenderCanCast(matrixStack, spell.consume((Entity)player, true));
                }
                ++i;
            }
        }
    }

    private static boolean isPlayerOwned(Player player, ISingleElementStorage storage) {
        return CapabilityElementStorage.get((ICapabilityProvider)player).map(s -> s.forElement(storage.getElementType())).map(s -> s.getElementAmount() == storage.getElementAmount() && s.getElementCapacity() == storage.getElementCapacity()).orElse(false);
    }

    private static List<ISingleElementStorage> getElementStorage(Player player) {
        Optional holder;
        Minecraft minecraft = Minecraft.m_91087_();
        HitResult result = minecraft.f_91077_;
        if (result != null && minecraft.f_91066_.m_92176_().m_90612_()) {
            List<ISingleElementStorage> storages;
            BlockEntity tile;
            BlockPos pos = result.m_6662_() == HitResult.Type.BLOCK ? ((BlockHitResult)result).m_82425_() : null;
            BlockEntity blockEntity = tile = pos != null ? minecraft.f_91074_.f_19853_.m_7702_(pos) : null;
            if (tile != null && !(storages = CapabilityElementStorage.get((ICapabilityProvider)tile).filter(storage -> storage.doesRenderGauge() || GuiHelper.showDebugInfo()).map(GuiHandler::splitStorage).orElse(Collections.emptyList())).isEmpty()) {
                return storages;
            }
        }
        if ((holder = EntityHelper.handStream(player).map(stack -> CapabilityElementStorage.get((ICapabilityProvider)stack).resolve()).mapMulti(Optional::ifPresent).findFirst()).isPresent()) {
            return GuiHandler.splitStorage((IElementStorage)holder.get());
        }
        Optional playerStorage = CapabilityElementStorage.get((ICapabilityProvider)player).resolve();
        if (playerStorage.isEmpty()) {
            return Collections.emptyList();
        }
        ElementType spellElementType = EntityHelper.handStream(player).map(stack -> {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ISpellHolder) {
                return SpellHelper.getSpell(stack).getElementType();
            }
            return ElementType.NONE;
        }).filter(type -> type != ElementType.NONE).findFirst().orElse(ElementType.NONE);
        ArrayList<ElementType> list = new ArrayList<ElementType>(4);
        if (spellElementType != ElementType.NONE) {
            list.add(spellElementType);
        }
        player.getCapability(IJewelHandler.JEWEL_HANDLER_CAPABILITY).ifPresent(handler -> handler.getActiveJewels().stream().map(Jewel::getElementType).distinct().filter(type -> type != ElementType.NONE && type != spellElementType).forEach(list::add));
        return GuiHandler.splitStorage((IElementStorage)playerStorage.get(), list);
    }

    private static List<ISingleElementStorage> splitStorage(IElementStorage storage) {
        if (storage instanceof ISingleElementStorage) {
            ISingleElementStorage singleElementStorage = (ISingleElementStorage)storage;
            return Collections.singletonList(singleElementStorage);
        }
        return GuiHandler.splitStorage(storage, ElementType.ALL_VALID);
    }

    private static List<ISingleElementStorage> splitStorage(IElementStorage storage, List<ElementType> elementTypes) {
        if (storage instanceof ISingleElementStorage) {
            ISingleElementStorage singleElementStorage = (ISingleElementStorage)storage;
            return elementTypes.contains(singleElementStorage.getElementType()) ? List.of(singleElementStorage) : Collections.emptyList();
        }
        return elementTypes.stream().mapMulti((type, downstream) -> downstream.accept(storage.forElement((ElementType)type))).filter(s -> s.getElementCapacity() > 0).toList();
    }

    private static Spell getSpell() {
        return EntityHelper.handStream((Player)Minecraft.m_91087_().f_91074_).map(stack -> {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ISpellHolder) {
                return SpellHelper.getSpell(stack);
            }
            return (Spell)Spells.NONE.get();
        }).filter(Spell::isValid).findFirst().orElseGet((Supplier<Spell>)Spells.NONE);
    }

    private static void doRenderElementGauge(PoseStack matrixStack, int element, int max, ElementType type, int index) {
        GuiHelper.renderElementGauge(matrixStack, GuiHandler.getXOffset() - 32 - 20 * index, GuiHandler.getYOffset() - 8, element, max, type);
    }

    public static int getYOffset() {
        return Minecraft.m_91087_().m_91268_().m_85446_() / 2 + (Integer)ECConfig.CLIENT.gaugeOffsetX.get();
    }

    public static int getXOffset() {
        return Minecraft.m_91087_().m_91268_().m_85445_() / 2 + (Integer)ECConfig.CLIENT.gaugeOffsetY.get();
    }

    private static void doRenderCanCast(PoseStack matrixStack, boolean canCast) {
        GuiHelper.renderCanCast(matrixStack, GuiHandler.getXOffset() - 21, GuiHandler.getYOffset() + 3, canCast);
    }
}

