/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity.player;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.curios.CuriosInteractions;

public class PlayerElementStorage
implements IElementStorage {
    private int tickCount = -1;
    private final Player player;
    private final List<IElementStorage> storages = new ArrayList<IElementStorage>();

    private PlayerElementStorage(Player player) {
        this.player = player;
    }

    @Nullable
    public static ICapabilityProvider createProvider(final Player player) {
        return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY != null ? new ICapabilityProvider(){
            final PlayerElementStorage storage;
            {
                this.storage = new PlayerElementStorage(player);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
                return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.storage));
            }
        } : null;
    }

    @Override
    public int getElementAmount(ElementType type) {
        return this.getStorages().stream().mapToInt(storage -> storage.getElementAmount(type)).sum();
    }

    @Override
    public int getElementCapacity(ElementType type) {
        return this.getStorages().stream().mapToInt(storage -> storage.getElementCapacity(type)).sum();
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        AtomicInteger remaining = new AtomicInteger(count);
        this.getStorages().forEach(storage -> remaining.set(storage.insertElement(remaining.get(), type, simulate)));
        return remaining.get();
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        AtomicInteger extracted = new AtomicInteger(0);
        this.getStorages().forEach(storage -> {
            int e = extracted.get();
            extracted.set(e + storage.extractElement(count - e, type, simulate));
        });
        return extracted.get();
    }

    @Override
    public boolean usableInInventory() {
        return true;
    }

    private List<IElementStorage> getStorages() {
        if (this.tickCount != this.player.f_19797_) {
            this.storages.clear();
            Inventory inventory = this.player.m_150109_();
            for (int i2 = 0; i2 < inventory.m_6643_(); ++i2) {
                CapabilityElementStorage.get((ICapabilityProvider)inventory.m_8020_(i2)).filter(IElementStorage::usableInInventory).ifPresent(this.storages::add);
            }
            if (ECinteractions.isCuriosActive()) {
                CuriosInteractions.getHolders((LivingEntity)this.player).stream().mapMulti((i, downstream) -> CapabilityElementStorage.get((ICapabilityProvider)i).ifPresent(downstream::accept)).filter(IElementStorage::usableInInventory).forEach(this.storages::add);
            }
            this.tickCount = this.player.f_19797_;
        }
        return this.storages;
    }
}

