/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.menu.IMenuOpenListener;
import sirttas.elementalcraft.entity.player.PlayerElementStorage;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.jewel.handler.ClientJewelHandler;
import sirttas.elementalcraft.jewel.handler.JewelHandler;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class EntityHandler {
    private EntityHandler() {
    }

    @SubscribeEvent
    public static void onEntityUseItemTick(LivingEntityUseItemEvent.Tick event) {
        int fastDraw = ToolInfusionHelper.getFasterDraw(event.getItem());
        if (fastDraw >= 0 && event.getDuration() % fastDraw == 0) {
            event.setDuration(event.getDuration() - 1);
        }
    }

    @SubscribeEvent
    public static void onEntityLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level world = entity.f_19853_;
        if (!world.f_46443_ && world.m_5822_().nextDouble() >= ToolInfusionHelper.getDodge((Entity)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag tag;
        Player player = event.getPlayer();
        if (Boolean.TRUE.equals(ECConfig.COMMON.playersSpawnWithBook.get()) && !event.getEntityLiving().m_183503_().f_46443_ && !(tag = player.getPersistentData().m_128469_("PlayerPersisted")).m_128471_("has_elementopedia")) {
            ItemStack book = new ItemStack((ItemLike)ECItems.ELEMENTOPEDIA);
            book.m_41784_().m_128359_("patchouli:book", "elementalcraft:element_book");
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)book);
            tag.m_128379_("has_elementopedia", true);
            player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ICapabilityProvider provider = PlayerElementStorage.createProvider(player);
            event.addCapability(ElementalCraft.createRL("element_storage"), provider);
            if (entity.f_19853_.f_46443_) {
                event.addCapability(ElementalCraft.createRL("jewel"), ClientJewelHandler.createProvider());
            } else {
                event.addCapability(ElementalCraft.createRL("jewel"), JewelHandler.createProvider(entity, (IElementStorage)CapabilityElementStorage.get(provider).orElse(null)));
            }
        }
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof IMenuOpenListener) {
            IMenuOpenListener listener = (IMenuOpenListener)abstractContainerMenu;
            listener.onOpen(event.getPlayer());
        }
    }
}

