/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block.rune;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.data.IDataWrapper;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.data.predicate.block.rune.IRunePredicate;

public class HasRunePredicate
implements IRunePredicate {
    public static final String NAME = "has_rune";
    @ObjectHolder(value="elementalcraft:has_rune")
    public static final BlockPosPredicateType<HasRunePredicate> TYPE = null;
    public static final Codec<HasRunePredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IDataWrapper.codec(ElementalCraftApi.RUNE_MANAGER).fieldOf("rune").forGetter(p -> p.rune), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(p -> p.count)).apply((Applicative)builder, HasRunePredicate::new));
    private final int count;
    private final IDataWrapper<Rune> rune;

    public HasRunePredicate(ResourceLocation runeId) {
        this(runeId, 1);
    }

    public HasRunePredicate(ResourceLocation runeId, int count) {
        this((IDataWrapper<Rune>)ElementalCraftApi.RUNE_MANAGER.getWrapper(runeId), count);
    }

    public HasRunePredicate(IDataWrapper<Rune> rune) {
        this(rune, 1);
    }

    public HasRunePredicate(IDataWrapper<Rune> rune, int count) {
        this.count = count;
        this.rune = rune;
    }

    @Override
    public boolean test(IRuneHandler handler) {
        return this.rune.isPresent() && handler.getRuneCount((Rune)this.rune.get()) >= this.count;
    }

    public BlockPosPredicateType<HasRunePredicate> getType() {
        return TYPE;
    }
}

