/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;

public class RangeFromSpawnPredicate
implements IBlockPosPredicate {
    public static final String NAME = "range_from_spawn";
    @ObjectHolder(value="elementalcraft:range_from_spawn")
    public static final BlockPosPredicateType<RangeFromSpawnPredicate> TYPE = null;
    public static final Codec<RangeFromSpawnPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("range").forGetter(p -> p.range)).apply((Applicative)builder, RangeFromSpawnPredicate::new));
    private final int range;
    private final int rangeSq;

    public RangeFromSpawnPredicate(int range) {
        this.range = range;
        this.rangeSq = range * range;
    }

    public BlockPosPredicateType<RangeFromSpawnPredicate> getType() {
        return TYPE;
    }

    public boolean test(LevelReader level, BlockPos pos) {
        BlockPos blockPos;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockPos = serverLevel.m_8900_();
        } else {
            blockPos = BlockPos.f_121853_;
        }
        BlockPos spawn = blockPos;
        return new BlockPos(spawn.m_123341_(), 0, spawn.m_123343_()).m_123331_((Vec3i)new BlockPos(pos.m_123341_(), 0, pos.m_123343_())) > (double)this.rangeSq;
    }
}

