/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.container;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;

public class ECContainerHelper {
    private ECContainerHelper() {
    }

    public static IItemHandler getItemHandlerAt(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelper.getBlockEntity(world, pos).map(t -> (IItemHandler)t.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElseGet(() -> {
            if (t instanceof WorldlyContainer && side != null) {
                return new SidedInvWrapper((WorldlyContainer)t, side);
            }
            if (t instanceof Container) {
                return new InvWrapper((Container)t);
            }
            return EmptyHandler.INSTANCE;
        })).orElse(EmptyHandler.INSTANCE);
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return ItemStack.m_41746_((ItemStack)stack1, (ItemStack)stack2) && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean stackEqualCount(ItemStack stack1, ItemStack stack2) {
        return ItemStack.m_41746_((ItemStack)stack1, (ItemStack)stack2) && stack1.m_41613_() == stack2.m_41613_();
    }

    public static int getSlotFor(Container inv, ItemStack stack) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_() || !ECContainerHelper.stackEqualExact(stack, current)) continue;
            return i;
        }
        return -1;
    }

    public static int getItemCount(Container inv) {
        return (int)IntStream.range(0, inv.m_6643_()).filter(i -> !inv.m_8020_(i).m_41619_()).count();
    }

    public static boolean isEmpty(IItemHandler targetInv) {
        for (int i = 0; i < targetInv.getSlots(); ++i) {
            if (targetInv.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }
}

