/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.client;

import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.StringUtils;
import sirttas.elementalcraft.api.tooltip.ElementGaugeTooltip;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.block.diffuser.DiffuserRenderer;
import sirttas.elementalcraft.block.entity.renderer.ECRenderers;
import sirttas.elementalcraft.block.instrument.io.mill.AirMillRenderer;
import sirttas.elementalcraft.block.pipe.ElementPipeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.directional.acceleration.AccelerationShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.vortex.VortexShrineUpgradeRenderer;
import sirttas.elementalcraft.block.source.SourceRenderer;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerRenderer;
import sirttas.elementalcraft.container.menu.screen.ECScreens;
import sirttas.elementalcraft.gui.tooltip.ElementGaugeClientTooltip;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.curios.CuriosConstants;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.rune.Runes;
import sirttas.elementalcraft.spell.airshield.AirShieldSpellRenderer;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECClientHandler {
    private ECClientHandler() {
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ECRenderers.initRenderLayouts();
        ECScreens.initScreenFactories();
        ECClientHandler.registerTooltipImages();
    }

    private static void registerTooltipImages() {
        MinecraftForgeClient.registerTooltipComponentFactory(ElementGaugeTooltip.class, ElementGaugeClientTooltip::new);
        MinecraftForgeClient.registerTooltipComponentFactory(AbstractElementContainerBlock.Tooltip.class, AbstractElementContainerBlock.ClientTooltip::new);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        Runes.registerModels(ECClientHandler::addModel);
        Jewels.registerModels(ECClientHandler::addModel);
        ForgeModelBakery.addSpecialModel((ResourceLocation)ElementPipeRenderer.SIDE_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)ElementPipeRenderer.EXTRACT_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)ElementPipeRenderer.PRIORITY_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)SolarSynthesizerRenderer.LENSE_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)AirMillRenderer.BLADES_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)DiffuserRenderer.CUBE_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)AccelerationShrineUpgradeRenderer.CLOCK_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)VortexShrineUpgradeRenderer.RING_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)SourceRenderer.STABILIZER_LOCATION);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addModel(ResourceLocation model) {
        String path = StringUtils.removeStart((String)StringUtils.removeEnd((String)model.m_135815_(), (String)".json"), (String)"models/item/");
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation(model.m_135827_(), path), "inventory"));
    }

    @SubscribeEvent
    public static void stitchTextures(TextureStitchEvent.Pre event) {
        ECClientHandler.addSprite(event, SolarSynthesizerRenderer.BEAM);
        ECClientHandler.addSprite(event, AirShieldSpellRenderer.BACKGROUND);
        ECClientHandler.addSprite(event, AirShieldSpellRenderer.BLADE);
        if (ECinteractions.isCuriosActive()) {
            event.addSprite(CuriosConstants.EMPTY_ELEMENT_HOLDER_SLOT);
        }
    }

    private static void addSprite(TextureStitchEvent.Pre event, Material sprite) {
        if (event.getAtlas().m_118330_().equals((Object)sprite.m_119193_())) {
            event.addSprite(sprite.m_119203_());
        }
    }
}

