/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.value;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;

public class StepsSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "steps";
    @ObjectHolder(value="elementalcraft:steps")
    public static final SourceTraitValueProviderType<StepsSourceTraitValueProvider> TYPE = null;
    public static final Codec<StepsSourceTraitValueProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Step.CODEC.listOf().fieldOf(NAME).forGetter(p -> p.steps)).apply((Applicative)builder, StepsSourceTraitValueProvider::new));
    private final List<Step> steps;

    public static Builder builder() {
        return new Builder();
    }

    private StepsSourceTraitValueProvider(Collection<Step> steps) {
        this.steps = ImmutableList.copyOf(steps);
    }

    @Override
    public ISourceTraitValue roll(SourceTrait trait, Level level, BlockPos pos) {
        List<Step> list = this.steps.stream().filter(s -> s.predicate().test((LevelReader)level, pos)).toList();
        int roll = level.f_46441_.nextInt(list.stream().mapToInt(Step::weight).sum());
        for (Step step : list) {
            if ((roll -= step.weight()) >= 0) continue;
            return step;
        }
        return null;
    }

    @Override
    public SourceTraitValueProviderType<? extends ISourceTraitValueProvider> getType() {
        return TYPE;
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        IntTag intTag;
        return tag instanceof IntTag && (intTag = (IntTag)tag).m_7047_() < this.steps.size() ? (ISourceTraitValue)this.steps.get(intTag.m_7047_()) : null;
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        IntTag intTag;
        if (value instanceof Step) {
            Step step = (Step)value;
            intTag = IntTag.m_128679_((int)this.steps.indexOf(step));
        } else {
            intTag = null;
        }
        return intTag;
    }

    public static class Builder {
        private final List<Step> steps = new ArrayList<Step>();

        private Builder() {
        }

        public Builder step(String translationKey, int weight, float value) {
            return this.step(translationKey, weight, value, IBlockPosPredicate.any());
        }

        public Builder step(String translationKey, int weight, float value, IBlockPosPredicate predicate) {
            this.steps.add(new Step(translationKey, weight, value, predicate));
            return this;
        }

        public StepsSourceTraitValueProvider build() {
            return new StepsSourceTraitValueProvider(this.steps);
        }
    }

    private record Step(String translationKey, int weight, float value, IBlockPosPredicate predicate) implements ISourceTraitValue
    {
        public static final Codec<Step> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(Step::translationKey), (App)Codec.INT.fieldOf("weight").forGetter(Step::weight), (App)Codec.FLOAT.fieldOf("value").forGetter(Step::value), (App)IBlockPosPredicate.CODEC.optionalFieldOf("predicate", (Object)IBlockPosPredicate.any()).forGetter(Step::predicate)).apply((Applicative)builder, Step::new));

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public Component getDescription() {
            return new TranslatableComponent(this.translationKey);
        }
    }
}

