/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.block.source.trait.value.LinearSourceTraitValueProvider;

public class RangeBasedSourceTraitValueProvider
extends LinearSourceTraitValueProvider {
    public static final String NAME = "range_based";
    @ObjectHolder(value="elementalcraft:range_based")
    public static final SourceTraitValueProviderType<RangeBasedSourceTraitValueProvider> TYPE = null;
    public static final Codec<RangeBasedSourceTraitValueProvider> CODEC = RecordCodecBuilder.create(builder -> RangeBasedSourceTraitValueProvider.codec(builder).and((App)Codec.FLOAT.fieldOf("weight").forGetter(p -> Float.valueOf(p.weight))).apply((Applicative)builder, RangeBasedSourceTraitValueProvider::new));
    private final float weight;

    public RangeBasedSourceTraitValueProvider(String translationKey, float end, float weight) {
        this(translationKey, 0.0f, end, weight);
    }

    public RangeBasedSourceTraitValueProvider(String translationKey, float start, float end, float weight) {
        super(translationKey, start, end);
        this.weight = weight;
    }

    @Override
    public ISourceTraitValue roll(SourceTrait trait, Level level, BlockPos pos) {
        BlockPos blockPos;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockPos = serverLevel.m_8900_();
        } else {
            blockPos = BlockPos.f_121853_;
        }
        BlockPos spawn = blockPos;
        double rangeSq = new BlockPos(spawn.m_123341_(), 0, spawn.m_123343_()).m_123331_((Vec3i)new BlockPos(pos.m_123341_(), 0, pos.m_123343_()));
        return this.createValue(this.start + (float)(rangeSq / (rangeSq + (double)(level.f_46441_.nextFloat() * this.weight * this.weight))) * (this.end - this.start));
    }

    @Override
    public SourceTraitValueProviderType<? extends ISourceTraitValueProvider> getType() {
        return TYPE;
    }
}

