/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.value;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;

public class LinearSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "linear";
    @ObjectHolder(value="elementalcraft:linear")
    public static final SourceTraitValueProviderType<LinearSourceTraitValueProvider> TYPE = null;
    public static final Codec<LinearSourceTraitValueProvider> CODEC = RecordCodecBuilder.create(builder -> LinearSourceTraitValueProvider.codec(builder).apply((Applicative)builder, LinearSourceTraitValueProvider::new));
    protected final String translationKey;
    protected final float start;
    protected final float end;

    public LinearSourceTraitValueProvider(String translationKey, float end) {
        this(translationKey, 0.0f, end);
    }

    public LinearSourceTraitValueProvider(String translationKey, float start, float end) {
        this.translationKey = translationKey;
        this.start = start;
        this.end = end;
    }

    protected static <T extends LinearSourceTraitValueProvider> Products.P3<RecordCodecBuilder.Mu<T>, String, Float, Float> codec(RecordCodecBuilder.Instance<T> builder) {
        return builder.group((App)Codec.STRING.fieldOf("name").forGetter(p -> p.translationKey), (App)Codec.FLOAT.optionalFieldOf("start", (Object)Float.valueOf(0.0f)).forGetter(LinearSourceTraitValueProvider::getStart), (App)Codec.FLOAT.fieldOf("end").forGetter(LinearSourceTraitValueProvider::getEnd));
    }

    public float getStart() {
        return this.start;
    }

    public float getEnd() {
        return this.end;
    }

    @Override
    public ISourceTraitValue roll(SourceTrait trait, Level level, BlockPos pos) {
        return this.createValue(this.start + level.f_46441_.nextFloat() * (this.end - this.start));
    }

    @Override
    public SourceTraitValueProviderType<? extends ISourceTraitValueProvider> getType() {
        return TYPE;
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        ISourceTraitValue iSourceTraitValue;
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            iSourceTraitValue = this.createValue(floatTag.m_7057_());
        } else {
            iSourceTraitValue = null;
        }
        return iSourceTraitValue;
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        FloatTag floatTag;
        if (value instanceof SourceTraitValue) {
            SourceTraitValue sourceTraitValue = (SourceTraitValue)value;
            floatTag = FloatTag.m_128566_((float)sourceTraitValue.value);
        } else {
            floatTag = null;
        }
        return floatTag;
    }

    protected ISourceTraitValue createValue(float value) {
        return new SourceTraitValue(value);
    }

    private class SourceTraitValue
    implements ISourceTraitValue {
        private final float value;

        private SourceTraitValue(float value) {
            this.value = value;
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public Component getDescription() {
            return new TranslatableComponent("source_trait.elementalcraft.linear", new Object[]{new TranslatableComponent(LinearSourceTraitValueProvider.this.translationKey), Math.round(this.value * 100.0f / LinearSourceTraitValueProvider.this.end)});
        }
    }
}

