/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;

public class FixedSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "fixed";
    @ObjectHolder(value="elementalcraft:fixed")
    public static final SourceTraitValueProviderType<FixedSourceTraitValueProvider> TYPE = null;
    public static final Codec<FixedSourceTraitValueProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(p -> p.translationKey), (App)Codec.FLOAT.fieldOf("value").forGetter(FixedSourceTraitValueProvider::getValue)).apply((Applicative)builder, FixedSourceTraitValueProvider::new));
    private final String translationKey;
    private final float value;

    public FixedSourceTraitValueProvider(String translationKey, float value) {
        this.translationKey = translationKey;
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public ISourceTraitValue roll(SourceTrait trait, Level level, BlockPos pos) {
        return new SourceTraitValue(this.value);
    }

    @Override
    public SourceTraitValueProviderType<? extends ISourceTraitValueProvider> getType() {
        return TYPE;
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        SourceTraitValue sourceTraitValue;
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            sourceTraitValue = new SourceTraitValue(floatTag.m_7057_());
        } else {
            sourceTraitValue = null;
        }
        return sourceTraitValue;
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        FloatTag floatTag;
        if (value instanceof SourceTraitValue) {
            SourceTraitValue sourceTraitValue = (SourceTraitValue)value;
            floatTag = FloatTag.m_128566_((float)sourceTraitValue.value);
        } else {
            floatTag = null;
        }
        return floatTag;
    }

    private class SourceTraitValue
    implements ISourceTraitValue {
        private final float value;

        private SourceTraitValue(float value) {
            this.value = value;
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public Component getDescription() {
            return new TranslatableComponent(FixedSourceTraitValueProvider.this.translationKey);
        }
    }
}

