/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;

public class SourceTraitHelper {
    private SourceTraitHelper() {
    }

    @Nonnull
    public static Map<SourceTrait, ISourceTraitValue> loadTraits(@Nullable CompoundTag tag) {
        TreeMap<SourceTrait, ISourceTraitValue> traits = new TreeMap<SourceTrait, ISourceTraitValue>();
        SourceTraitHelper.loadTraits(tag, traits);
        return traits;
    }

    public static void loadTraits(@Nullable CompoundTag tag, @Nonnull Map<SourceTrait, ISourceTraitValue> traits) {
        traits.clear();
        if (tag != null) {
            for (String key : tag.m_128431_()) {
                ISourceTraitValue value;
                SourceTrait trait = (SourceTrait)ElementalCraftApi.SOURCE_TRAIT_MANAGER.get(new ResourceLocation(key));
                if (trait == null || (value = trait.load(tag.m_128423_(key))) == null) continue;
                traits.put(trait, value);
            }
        }
    }

    @Nonnull
    public static CompoundTag saveTraits(@Nonnull Map<SourceTrait, ISourceTraitValue> traits) {
        CompoundTag traitTag = new CompoundTag();
        traits.forEach((trait, value) -> {
            Tag tag = trait.save((ISourceTraitValue)value);
            if (tag != null) {
                traitTag.m_128365_(trait.getId().toString(), tag);
            }
        });
        return traitTag;
    }
}

