/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.entity.renderer.IECRenderer;
import sirttas.elementalcraft.block.source.SourceBlockEntity;

public class SourceRenderer
implements IECRenderer<SourceBlockEntity> {
    public static final ResourceLocation STABILIZER_LOCATION = ElementalCraft.createRL("block/source_stabilizer");
    private BakedModel stabilizerModel;

    public void render(@Nonnull SourceBlockEntity source, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.stabilizerModel == null) {
            this.stabilizerModel = minecraft.m_91304_().getModel(STABILIZER_LOCATION);
        }
        if (source.isStabilized()) {
            ElementType elementType = source.getElementStorage().getElementType();
            float r = elementType.getRed();
            float g = elementType.getGreen();
            float b = elementType.getBlue();
            matrixStack.m_85837_(0.5, 0.0, 0.5);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122270_(this.getAngle(partialTicks) / 20.0f));
            matrixStack.m_85837_(-0.5, 0.0, -0.5);
            matrixStack.m_85837_(0.0, -0.25, 0.0);
            minecraft.m_91289_().m_110937_().renderModel(matrixStack.m_85850_(), buffer.m_6299_(RenderType.m_110466_()), source.m_58900_(), this.stabilizerModel, r, g, b, light, overlay, this.getModelData(this.stabilizerModel, source));
        }
    }
}

