/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.data.IDataWrapper;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.source.SourceElementStorage;
import sirttas.elementalcraft.block.source.trait.SourceTraitHelper;
import sirttas.elementalcraft.block.source.trait.SourceTraits;
import sirttas.elementalcraft.particle.ParticleHelper;

public class SourceBlockEntity
extends AbstractECBlockEntity
implements IElementTypeProvider {
    @ObjectHolder(value="elementalcraft:source")
    public static final BlockEntityType<SourceBlockEntity> TYPE = null;
    private boolean analyzed = false;
    private boolean stabilized = false;
    private final SourceElementStorage elementStorage = new SourceElementStorage(this);
    private final Map<SourceTrait, ISourceTraitValue> traits;

    public SourceBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.elementStorage.setElementType(ElementType.getElementType(state));
        this.traits = new TreeMap<SourceTrait, ISourceTraitValue>();
    }

    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SourceBlockEntity source) {
        source.initTraits();
        if (source.elementStorage.isExhausted()) {
            source.elementStorage.insertElement(source.getRecoverRate(), false);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, SourceBlockEntity source) {
        source.addParticle(level.f_46441_);
    }

    private void initTraits() {
        if (this.elementStorage.getElementType() == ElementType.NONE) {
            this.elementStorage.setElementType(ElementType.getElementType(this.m_58900_()));
        }
        if (this.traits.isEmpty()) {
            for (SourceTrait trait : ElementalCraftApi.SOURCE_TRAIT_MANAGER.getData().values()) {
                ISourceTraitValue value = trait.roll(this.f_58857_, this.f_58858_);
                if (value == null) continue;
                if (trait == SourceTraits.ELEMENT_CAPACITY.get()) {
                    this.elementStorage.setElementCapacity(Math.round(value.getValue()));
                }
                this.traits.put(trait, value);
            }
        }
    }

    private void addParticle(Random rand) {
        if (this.f_58857_.f_46443_ && rand.nextFloat() < 0.2f) {
            if (this.elementStorage.isExhausted()) {
                ParticleHelper.createExhaustedSourceParticle(this.elementStorage.getElementType(), this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_), rand);
            } else {
                ParticleHelper.createSourceParticle(this.elementStorage.getElementType(), this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_), rand);
            }
        }
    }

    public boolean isExhausted() {
        return this.elementStorage.isExhausted();
    }

    public int getRecoverRate() {
        float rate = this.getTrait(SourceTraits.RECOVER_RATE);
        float diurnal = 1.0f + this.getTrait(SourceTraits.DIURNAL_NOCTURNAL) * (float)(this.f_58857_.m_46461_() ? 1 : (this.f_58857_.m_46462_() ? -1 : 0));
        return Math.round(rate * diurnal) + (this.stabilized ? 20 : 0);
    }

    public float getSpeedModifier() {
        return 1.0f + this.getTrait(SourceTraits.GENEROSITY);
    }

    public float getPreservationModifier() {
        return 1.0f + this.getTrait(SourceTraits.THRIFTINESS);
    }

    private float getTrait(IDataWrapper<SourceTrait> trait) {
        return trait.isPresent() ? this.getTrait((SourceTrait)trait.get()) : 0.0f;
    }

    private float getTrait(SourceTrait trait) {
        ISourceTraitValue value = this.traits.get(trait);
        return value != null ? value.getValue() : 0.0f;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public void setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
        this.m_6596_();
    }

    public boolean isStabilized() {
        return this.stabilized;
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        this.m_6596_();
    }

    @Override
    public ElementType getElementType() {
        return this.elementStorage.getElementType();
    }

    public Map<SourceTrait, ISourceTraitValue> getTraits() {
        return this.traits;
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("element_storage")) {
            this.elementStorage.deserializeNBT(compound.m_128469_("element_storage"));
        }
        this.elementStorage.setExhausted(compound.m_128471_("exhausted"));
        this.analyzed = compound.m_128471_("analyzed");
        this.stabilized = compound.m_128471_("stabilized");
        SourceTraitHelper.loadTraits(compound.m_128469_("traits"), this.traits);
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("element_storage", (Tag)this.elementStorage.serializeNBT());
        compound.m_128379_("exhausted", this.elementStorage.isExhausted());
        compound.m_128379_("analyzed", this.analyzed);
        compound.m_128379_("stabilized", this.stabilized);
        compound.m_128365_("traits", (Tag)SourceTraitHelper.saveTraits(this.traits));
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

