/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import sirttas.elementalcraft.block.entity.renderer.IECRenderer;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.block.sorter.SorterBlockEntity;

public class SorterRenderer
implements IECRenderer<SorterBlockEntity> {
    public void render(SorterBlockEntity sorter, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        HitResult mouseOver = Minecraft.m_91087_().f_91077_;
        boolean sneeking = Minecraft.m_91087_().f_91074_.m_6144_();
        List<ItemStack> stacks = sorter.getStacks();
        if (mouseOver != null && mouseOver.m_6662_() == HitResult.Type.BLOCK && !stacks.isEmpty()) {
            poseStack.m_85836_();
            BlockHitResult result = (BlockHitResult)mouseOver;
            if (sorter.m_58899_().equals((Object)result.m_82425_())) {
                int i;
                int index = sorter.getIndex();
                Quaternion rotation = result.m_82434_().m_122406_();
                Vector3f newPos = new Vector3f(0.0f, 0.125f, 0.0625f);
                poseStack.m_85837_(0.5, 0.5, 0.5);
                newPos.m_122251_(rotation);
                poseStack.m_85837_((double)newPos.m_122239_(), (double)newPos.m_122260_(), (double)newPos.m_122269_());
                poseStack.m_85845_(rotation);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                this.renderItem(stacks.get(index), poseStack, buffer, light, overlay);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_85836_();
                this.translate(poseStack, 0.5, sneeking);
                for (i = index - 1; i >= 0; --i) {
                    this.translate(poseStack, 0.5, sneeking);
                    this.renderItem(stacks.get(i), poseStack, buffer, light, overlay);
                }
                poseStack.m_85849_();
                poseStack.m_85836_();
                this.translate(poseStack, -0.5, sneeking);
                for (i = index + 1; i < stacks.size(); ++i) {
                    this.translate(poseStack, -0.5, sneeking);
                    this.renderItem(stacks.get(i), poseStack, buffer, light, overlay);
                }
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
        this.rendereRunes(sorter, partialTicks, poseStack, buffer, light, overlay);
    }

    private void rendereRunes(SorterBlockEntity sorter, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        poseStack.m_85837_(0.5, 0.5, 0.5);
        BlockState state = sorter.m_58900_();
        Quaternion rotation1 = ((Direction)state.m_61143_((Property)ISorterBlock.SOURCE)).m_122424_().m_122406_();
        Quaternion rotation2 = ((Direction)state.m_61143_((Property)ISorterBlock.TARGET)).m_122406_();
        Quaternion rotation = new Quaternion(rotation1.m_80140_() + rotation2.m_80140_(), rotation1.m_80150_() + rotation2.m_80150_(), rotation1.m_80153_() + rotation2.m_80153_(), rotation1.m_80156_() + rotation2.m_80156_());
        rotation.m_80160_();
        poseStack.m_85845_(rotation);
        poseStack.m_85837_(-0.5, -0.75, -0.5);
        this.renderRunes(poseStack, buffer, sorter.getRuneHandler(), this.getAngle(partialTicks), light, overlay);
    }

    private void translate(PoseStack matrixStack, double value, boolean sneeking) {
        if (sneeking) {
            matrixStack.m_85837_(-value, 0.0, 0.0);
        } else {
            matrixStack.m_85837_(0.0, value, 0.0);
        }
    }
}

