/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.ECContainerHelper;

public class SorterBlockEntity
extends AbstractECBlockEntity {
    @ObjectHolder(value="elementalcraft:sorter")
    public static final BlockEntityType<SorterBlockEntity> TYPE = null;
    private final List<ItemStack> stacks = Lists.newArrayList();
    private int index = 0;
    private float tick = 0.0f;
    private boolean alwaysInsert = false;
    private final RuneHandler runeHandler;

    public SorterBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.sorterMaxRunes.get(), this::m_6596_);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SorterBlockEntity sorter) {
        float speed = sorter.runeHandler.getBonus(Rune.BonusType.SPEED) + 1.0f;
        Integer cooldown = (Integer)ECConfig.COMMON.sorterCooldown.get();
        sorter.tick += Math.min(speed, (float)cooldown.intValue() * 64.0f);
        while (sorter.tick > (float)cooldown.intValue()) {
            if (!sorter.isPowered()) {
                sorter.transfer();
            }
            sorter.tick -= (float)cooldown.intValue();
        }
    }

    public InteractionResult addStack(ItemStack stack) {
        if (!this.stacks.isEmpty() && stack.m_41619_()) {
            this.stacks.clear();
            this.index = 0;
            this.m_6596_();
            return InteractionResult.SUCCESS;
        }
        if (this.stacks.size() < (Integer)ECConfig.COMMON.sorterMaxItem.get()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.stacks.add(copy);
            this.m_6596_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public List<ItemStack> getStacks() {
        return ImmutableList.copyOf(this.stacks);
    }

    @Nonnull
    public IRuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    public int getIndex() {
        return this.index;
    }

    private void transfer() {
        block4: {
            IItemHandler targetInv;
            IItemHandler sourceInv;
            block3: {
                BlockState state = this.m_58900_();
                Direction source = (Direction)state.m_61143_((Property)ISorterBlock.SOURCE);
                Direction target = (Direction)state.m_61143_((Property)ISorterBlock.TARGET);
                sourceInv = ECContainerHelper.getItemHandlerAt((BlockGetter)this.f_58857_, this.f_58858_.m_142300_(source), source.m_122424_());
                targetInv = ECContainerHelper.getItemHandlerAt((BlockGetter)this.f_58857_, this.f_58858_.m_142300_(target), target.m_122424_());
                if (!this.stacks.isEmpty()) break block3;
                for (int i = 0; i < sourceInv.getSlots(); ++i) {
                    ItemStack stack = sourceInv.getStackInSlot(i).m_41777_();
                    stack.m_41764_(1);
                    if (stack.m_41619_() || !this.doTransfer(sourceInv, targetInv, i, true)) continue;
                    this.doTransfer(sourceInv, targetInv, i, false);
                    return;
                }
                break block4;
            }
            if (!this.alwaysInsert && this.index <= 0 && !ECContainerHelper.isEmpty(targetInv)) break block4;
            ItemStack stack = this.stacks.get(this.index).m_41777_();
            for (int i = 0; i < sourceInv.getSlots(); ++i) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)sourceInv.getStackInSlot(i)) || !this.doTransfer(sourceInv, targetInv, i, true)) continue;
                this.doTransfer(sourceInv, targetInv, i, false);
                ++this.index;
                if (this.index >= this.stacks.size()) {
                    this.index = 0;
                }
                return;
            }
        }
    }

    private boolean doTransfer(IItemHandler sourceInv, IItemHandler targetInv, int i, boolean simulate) {
        ItemStack extracted = sourceInv.extractItem(i, 1, simulate);
        if (extracted.m_41619_()) {
            return false;
        }
        ItemStack stack = ItemHandlerHelper.insertItem((IItemHandler)targetInv, (ItemStack)extracted, (boolean)simulate);
        if (!simulate) {
            this.m_6596_();
        }
        return !stack.equals(extracted);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.readStacks(compound.m_128437_("stacks", 10));
        this.index = compound.m_128451_("index");
        if (this.index > this.stacks.size()) {
            this.index = 0;
        }
        this.alwaysInsert = compound.m_128471_("always_insert");
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
    }

    private void readStacks(ListTag listNbt) {
        this.stacks.clear();
        for (int i = 0; i < listNbt.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listNbt.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            this.stacks.add(itemstack);
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("stacks", (Tag)this.writeStacks());
        compound.m_128405_("index", this.index);
        compound.m_128379_("always_insert", this.alwaysInsert);
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    private ListTag writeStacks() {
        ListTag listTag = new ListTag();
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            listTag.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        return listTag;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
            return LazyOptional.of(this::getRuneHandler).cast();
        }
        return super.getCapability(cap, side);
    }
}

