/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shape.ShapeHelper;

public interface ISorterBlock {
    public static final DirectionProperty SOURCE = DirectionProperty.m_61549_((String)"source", (Direction[])Direction.values());
    public static final DirectionProperty TARGET = DirectionProperty.m_61549_((String)"target", (Direction[])Direction.values());

    default public VoxelShape getSourceShape(BlockState state) {
        return ECShapes.sourceShape((Direction)state.m_61143_((Property)SOURCE));
    }

    default public VoxelShape getTargetShape(BlockState state) {
        return ECShapes.targetShape((Direction)state.m_61143_((Property)TARGET));
    }

    public VoxelShape getCoreShape(BlockState var1);

    default public VoxelShape getCurentShape(BlockState state) {
        return Shapes.m_83124_((VoxelShape)this.getSourceShape(state), (VoxelShape[])new VoxelShape[]{this.getTargetShape(state), this.getCoreShape(state)}).m_83296_();
    }

    default public VoxelShape getShape(BlockState state, BlockPos pos, HitResult result) {
        if (result != null && result.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)result).m_82425_().equals((Object)pos)) {
            Vec3 hit = result.m_82450_();
            VoxelShape source = this.getSourceShape(state);
            VoxelShape target = this.getTargetShape(state);
            VoxelShape core = this.getCoreShape(state);
            if (ShapeHelper.vectorCollideWithShape(source, pos, hit)) {
                return source;
            }
            if (ShapeHelper.vectorCollideWithShape(target, pos, hit)) {
                return target;
            }
            if (ShapeHelper.vectorCollideWithShape(core, pos, hit)) {
                return core;
            }
        }
        return this.getCurentShape(state);
    }

    default public InteractionResult moveIO(BlockState state, Level world, BlockPos pos, BlockHitResult hit) {
        return this.moveIO(state, world, pos, hit, this.getShape(state, pos, (HitResult)hit));
    }

    default public InteractionResult moveIO(BlockState state, Level world, BlockPos pos, BlockHitResult hit, VoxelShape shape) {
        Direction direction = hit.m_82434_().m_122424_();
        if (state.m_61143_((Property)SOURCE) == direction || state.m_61143_((Property)TARGET) == direction) {
            return InteractionResult.PASS;
        }
        if (ECShapes.SOURCE_SHAPES.contains(shape)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)SOURCE, (Comparable)direction));
            return InteractionResult.SUCCESS;
        }
        if (ECShapes.TARGET_SHAPES.contains(shape)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)TARGET, (Comparable)direction));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

