/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.vacuum;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.vortex.VortexPullPlayerMessage;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.network.message.MessageHelper;
import sirttas.elementalcraft.particle.ParticleHelper;

public class VacuumShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:vacuumshrine")
    public static final BlockEntityType<VacuumShrineBlockEntity> TYPE = null;
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = VacuumShrineBlockEntity.createKey("vacuumshrine");

    public VacuumShrineBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PROPERTIES_KEY);
    }

    private List<? extends Entity> getEntities() {
        if (this.hasUpgrade(ShrineUpgrades.VORTEX)) {
            boolean protection = this.hasUpgrade(ShrineUpgrades.PROTECTION);
            return this.m_58904_().m_45976_(LivingEntity.class, this.getRangeBoundingBox()).stream().filter(e -> {
                Player player;
                return !(e instanceof Player && (player = (Player)e).m_7500_() || protection && !EntityHelper.isHostile((Entity)e));
            }).toList();
        }
        return this.m_58904_().m_45976_(ItemEntity.class, this.getRangeBoundingBox());
    }

    @Override
    protected boolean doPeriod() {
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)this.f_58857_, this.f_58858_.m_7495_(), Direction.UP);
        return this.hasUpgrade(ShrineUpgrades.PICKUP) ? this.pickup(inv) : this.pull(inv);
    }

    private boolean pickup(IItemHandler inv) {
        return this.getEntities().stream().findAny().map(entity -> {
            this.doPickup(inv, (ItemEntity)entity);
            return true;
        }).orElse(false);
    }

    private boolean pull(IItemHandler inv) {
        int consumeAmount = this.getConsumeAmount();
        double pullSpeed = this.getStrength();
        Vec3 pos3d = Vec3.m_82512_((Vec3i)this.m_58899_());
        this.getEntities().forEach(entity -> {
            if (this.elementStorage.getElementAmount() >= consumeAmount) {
                this.consumeElement(consumeAmount);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    MessageHelper.sendToPlayer(player, new VortexPullPlayerMessage(pos3d, pullSpeed));
                } else {
                    entity.m_20256_(pos3d.m_82546_(entity.m_20182_()).m_82541_().m_82542_(pullSpeed, pullSpeed, pullSpeed));
                }
                if (entity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entity;
                    if (pos3d.m_82554_(entity.m_20182_()) <= (double)(2.0f * Math.max(1.0f, this.getMultiplier(ShrineUpgrade.BonusType.RANGE)))) {
                        this.doPickup(inv, itemEntity);
                    }
                }
            }
        });
        return false;
    }

    private void doPickup(IItemHandler inv, ItemEntity entity) {
        entity.m_32045_(ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)entity.m_32055_(), (boolean)false));
        if (this.f_58857_.f_46443_) {
            ParticleHelper.createEnderParticle(this.f_58857_, entity.m_20182_(), 3, this.f_58857_.f_46441_);
        }
    }
}

