/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.horizontal;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.AbstractHorizontalShrineUpgradeBlock;

public class SpringalineShrineUpgradeBlock
extends AbstractHorizontalShrineUpgradeBlock {
    public static final String NAME = "shrine_upgrade_springaline";
    private static final VoxelShape BASE_NORTH = Block.m_49796_((double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0, (double)10.0);
    private static final VoxelShape PLATE_SOUTH_NORTH = Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)11.0);
    private static final VoxelShape PLATE_UP_NORTH = Block.m_49796_((double)6.0, (double)11.0, (double)5.0, (double)10.0, (double)12.0, (double)9.0);
    private static final VoxelShape PLATE_DOWN_NORTH = Block.m_49796_((double)6.0, (double)4.0, (double)5.0, (double)10.0, (double)5.0, (double)9.0);
    private static final VoxelShape PLATE_WEST_NORTH = Block.m_49796_((double)4.0, (double)6.0, (double)5.0, (double)5.0, (double)10.0, (double)9.0);
    private static final VoxelShape PLATE_EAST_NORTH = Block.m_49796_((double)11.0, (double)6.0, (double)5.0, (double)12.0, (double)10.0, (double)9.0);
    private static final VoxelShape PIPE_NORTH = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)4.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)BASE_NORTH, (VoxelShape[])new VoxelShape[]{PIPE_NORTH, PLATE_SOUTH_NORTH, PLATE_UP_NORTH, PLATE_DOWN_NORTH, PLATE_WEST_NORTH, PLATE_EAST_NORTH});
    private static final VoxelShape BASE_SOUTH = Block.m_49796_((double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0, (double)12.0);
    private static final VoxelShape PLATE_NORTH_SOUTH = Block.m_49796_((double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape PLATE_UP_SOUTH = Block.m_49796_((double)6.0, (double)11.0, (double)7.0, (double)10.0, (double)12.0, (double)11.0);
    private static final VoxelShape PLATE_DOWN_SOUTH = Block.m_49796_((double)6.0, (double)4.0, (double)7.0, (double)10.0, (double)5.0, (double)11.0);
    private static final VoxelShape PLATE_WEST_SOUTH = Block.m_49796_((double)4.0, (double)6.0, (double)7.0, (double)5.0, (double)10.0, (double)11.0);
    private static final VoxelShape PLATE_EAST_SOUTH = Block.m_49796_((double)11.0, (double)6.0, (double)7.0, (double)12.0, (double)10.0, (double)11.0);
    private static final VoxelShape PIPE_SOUTH = Block.m_49796_((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83124_((VoxelShape)BASE_SOUTH, (VoxelShape[])new VoxelShape[]{PIPE_SOUTH, PLATE_NORTH_SOUTH, PLATE_UP_SOUTH, PLATE_DOWN_SOUTH, PLATE_WEST_SOUTH, PLATE_EAST_SOUTH});
    private static final VoxelShape BASE_WEST = Block.m_49796_((double)4.0, (double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0);
    private static final VoxelShape PLATE_EAST_WEST = Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0);
    private static final VoxelShape PLATE_UP_WEST = Block.m_49796_((double)5.0, (double)11.0, (double)6.0, (double)9.0, (double)12.0, (double)10.0);
    private static final VoxelShape PLATE_DOWN_WEST = Block.m_49796_((double)5.0, (double)4.0, (double)6.0, (double)9.0, (double)5.0, (double)10.0);
    private static final VoxelShape PLATE_NORTH_WEST = Block.m_49796_((double)5.0, (double)6.0, (double)4.0, (double)9.0, (double)10.0, (double)5.0);
    private static final VoxelShape PLATE_SOUTH_WEST = Block.m_49796_((double)5.0, (double)6.0, (double)11.0, (double)9.0, (double)10.0, (double)12.0);
    private static final VoxelShape PIPE_WEST = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_WEST = Shapes.m_83124_((VoxelShape)BASE_WEST, (VoxelShape[])new VoxelShape[]{PIPE_WEST, PLATE_EAST_WEST, PLATE_UP_WEST, PLATE_DOWN_WEST, PLATE_NORTH_WEST, PLATE_SOUTH_WEST});
    private static final VoxelShape BASE_EAST = Block.m_49796_((double)6.0, (double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0);
    private static final VoxelShape PLATE_WEST_EAST = Block.m_49796_((double)5.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape PLATE_UP_EAST = Block.m_49796_((double)7.0, (double)11.0, (double)6.0, (double)11.0, (double)12.0, (double)10.0);
    private static final VoxelShape PLATE_DOWN_EAST = Block.m_49796_((double)7.0, (double)4.0, (double)6.0, (double)11.0, (double)5.0, (double)10.0);
    private static final VoxelShape PLATE_NORTH_EAST = Block.m_49796_((double)7.0, (double)6.0, (double)4.0, (double)11.0, (double)10.0, (double)5.0);
    private static final VoxelShape PLATE_SOUTH_EAST = Block.m_49796_((double)7.0, (double)6.0, (double)11.0, (double)11.0, (double)10.0, (double)12.0);
    private static final VoxelShape PIPE_EAST = Block.m_49796_((double)12.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_EAST = Shapes.m_83124_((VoxelShape)BASE_EAST, (VoxelShape[])new VoxelShape[]{PIPE_EAST, PLATE_WEST_EAST, PLATE_UP_EAST, PLATE_DOWN_EAST, PLATE_NORTH_EAST, PLATE_SOUTH_EAST});

    public SpringalineShrineUpgradeBlock() {
        super(ShrineUpgrades.SPRINGALINE);
    }

    public static VoxelShape getShape(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SpringalineShrineUpgradeBlock.getShape(state);
    }

    @Override
    public void m_6402_(@Nonnull Level level, BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        this.setShrineState(level, pos.m_142300_(this.getFacing(state)), BuddingShrineBlock.CrystalType.SPRINGALINE);
    }

    @Override
    @Deprecated
    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        this.setShrineState(level, pos.m_142300_(this.getFacing(state)), BuddingShrineBlock.CrystalType.AMETHYST);
    }

    private void setShrineState(Level level, BlockPos pos, BuddingShrineBlock.CrystalType type) {
        BlockState shrineState = level.m_8055_(pos);
        if (shrineState.m_60713_((Block)ECBlocks.BUDDING_SHRINE)) {
            level.m_46597_(pos, (BlockState)shrineState.m_61124_(BuddingShrineBlock.CRYSTAL_TYPE, (Comparable)((Object)type)));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.elementalcraft.springaline_shrine_upgrade").m_130940_(ChatFormatting.BLUE));
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }
}

