/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.property.ECProperties;

public abstract class AbstractShrineUpgradeBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Holder<ShrineUpgrade> upgrade;

    protected AbstractShrineUpgradeBlock(@Nonnull ResourceKey<ShrineUpgrade> key) {
        super(ECProperties.Blocks.BLOCK_NOT_SOLID);
        this.upgrade = ElementalCraft.SHRINE_UPGRADE_MANAGER.getOrCreateHolder(key);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    @Deprecated
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(@Nonnull Level world, BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntityHelper.getBlockEntityAs((BlockGetter)world, pos.m_142300_(this.getFacing(state)), AbstractShrineBlockEntity.class).ifPresent(AbstractECBlockEntity::m_6596_);
    }

    @Deprecated
    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntityHelper.getBlockEntityAs((BlockGetter)world, pos.m_142300_(this.getFacing(state)), AbstractShrineBlockEntity.class).ifPresent(AbstractECBlockEntity::m_6596_);
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Deprecated
    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        Direction facing = this.getFacing(state);
        return this.upgrade.m_203633_() && BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos.m_142300_(facing), AbstractShrineBlockEntity.class).filter(shrine -> shrine.getUpgradeDirections().contains(facing.m_122424_()) && this.getUpgrade().canUpgrade((AbstractShrineBlockEntity)shrine, level.m_8055_(pos).m_60713_((Block)this))).isPresent();
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nonnull
    @Deprecated
    public FluidState m_5888_(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    @Deprecated
    public void m_7458_(BlockState state, @Nonnull ServerLevel worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        } else {
            super.m_7458_(state, worldIn, pos, rand);
        }
    }

    public abstract Direction getFacing(BlockState var1);

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (this.upgrade.m_203633_()) {
            this.getUpgrade().addInformation(tooltip);
        }
    }

    public ShrineUpgrade getUpgrade() {
        return (ShrineUpgrade)this.upgrade.m_203334_();
    }
}

