/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.ore;

import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.loot.LootHelper;

public class OreShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:oreshrine")
    public static final BlockEntityType<OreShrineBlockEntity> TYPE = null;
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = OreShrineBlockEntity.createKey("oreshrine");

    public OreShrineBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findOre() {
        int range = this.getIntegerRange();
        return IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(0, this.f_58858_.m_123342_() + 1).mapToObj(y -> new BlockPos(this.f_58858_.m_123341_() + x, y, this.f_58858_.m_123343_() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(p -> this.f_58857_.m_8055_(p).m_204336_(Tags.Blocks.ORES)).findAny();
    }

    @Override
    public AABB getRangeBoundingBox() {
        int range = this.getIntegerRange();
        return new AABB(this.m_58899_()).m_82377_((double)range, 0.0, (double)range).m_82386_(0.0, -1.0, 0.0).m_82363_(0.0, 1.0 - (double)this.f_58858_.m_123342_(), 0.0);
    }

    @Override
    protected boolean doPeriod() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.findOre().map(p -> {
                OreShrineBlockEntity.harvest(serverLevel, p, this, Blocks.f_50069_.m_49966_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static void harvest(ServerLevel level, BlockPos pos, AbstractShrineBlockEntity shrine, BlockState newBlock) {
        int fortune = shrine.getUpgradeCount(ShrineUpgrades.FORTUNE);
        if (fortune > 0) {
            ItemStack pickaxe = new ItemStack((ItemLike)Items.f_42395_);
            pickaxe.m_41663_(Enchantments.f_44987_, fortune);
            LootHelper.getDrops(level, pos, pickaxe).forEach(s -> Block.m_49840_((Level)level, (BlockPos)shrine.m_58899_().m_7494_(), (ItemStack)s));
        } else {
            LootHelper.getDrops(level, pos, shrine.hasUpgrade(ShrineUpgrades.SILK_TOUCH)).forEach(s -> Block.m_49840_((Level)level, (BlockPos)shrine.m_58899_().m_7494_(), (ItemStack)s));
        }
        if (newBlock != null) {
            level.m_46597_(pos, newBlock);
        }
    }
}

