/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.lava;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.tag.ECTags;

public class LavaShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:lavashrine")
    public static final BlockEntityType<LavaShrineBlockEntity> TYPE = null;
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = LavaShrineBlockEntity.createKey("lavashrine");
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public LavaShrineBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findRock() {
        int range = Math.round(this.getProperties().range());
        return IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> new BlockPos(this.f_58858_.m_123341_() + x, this.f_58858_.m_123342_() + 1, this.f_58858_.m_123343_() + z))).flatMap(s -> s).filter(p -> this.f_58857_.m_8055_(p).m_204336_(ECTags.Blocks.LAVASHRINE_LIQUIFIABLES)).findAny();
    }

    @Override
    public AABB getRangeBoundingBox() {
        int range = Math.round(this.getProperties().range());
        return new AABB(this.m_58899_()).m_82377_((double)range, 0.0, (double)range).m_82386_(0.0, 1.0, 0.0);
    }

    @Override
    protected boolean doPeriod() {
        return this.findRock().map(p -> {
            this.f_58857_.m_46597_(p, Blocks.f_49991_.m_49966_());
            this.f_58857_.m_46796_(1501, p, 0);
            return true;
        }).orElse(false);
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

