/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.harvest;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.loot.LootHelper;

public class HarvestShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:harvestshrine")
    public static final BlockEntityType<HarvestShrineBlockEntity> TYPE = null;
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = HarvestShrineBlockEntity.createKey("harvestshrine");
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public HarvestShrineBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findCrop() {
        int range = this.getIntegerRange();
        return IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(-3, 1).mapToObj(y -> new BlockPos(this.f_58858_.m_123341_() + x, this.f_58858_.m_123342_() + y, this.f_58858_.m_123343_() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(p -> {
            BlockState blockstate = this.f_58857_.m_8055_(p);
            Block block = blockstate.m_60734_();
            return block instanceof CropBlock && ((CropBlock)block).m_52307_(blockstate);
        }).findAny();
    }

    private void handlePlanting(BlockPos pos, ItemLike provider, List<ItemStack> loots) {
        Item item = provider.m_5456_();
        if (this.hasUpgrade(ShrineUpgrades.PLANTING)) {
            loots.stream().filter(stack -> stack.m_41720_().equals(item)).findFirst().ifPresent(seeds -> {
                if (item instanceof BlockItem && ((BlockItem)item).m_40576_((BlockPlaceContext)new DirectionalPlaceContext(this.f_58857_, pos, Direction.DOWN, seeds, Direction.UP)).m_19077_()) {
                    seeds.m_41774_(1);
                    if (seeds.m_41619_()) {
                        loots.remove(seeds);
                    }
                }
            });
        }
    }

    @Override
    public AABB getRangeBoundingBox() {
        int range = this.getIntegerRange();
        return new AABB(this.m_58899_()).m_82377_((double)range, 0.0, (double)range).m_82363_(0.0, -2.0, 0.0).m_82386_(0.0, -1.0, 0.0);
    }

    @Override
    protected boolean doPeriod() {
        if (this.f_58857_ instanceof ServerLevel && !this.f_58857_.f_46443_) {
            return this.findCrop().map(p -> {
                List<ItemStack> loots = LootHelper.getDrops((ServerLevel)this.f_58857_, p);
                Block block = this.f_58857_.m_8055_(p).m_60734_();
                this.f_58857_.m_46961_(p, false);
                this.handlePlanting((BlockPos)p, (ItemLike)block, loots);
                loots.forEach(stack -> Block.m_49840_((Level)this.f_58857_, (BlockPos)p, (ItemStack)stack));
                return true;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

