/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.growth;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.tag.ECTags;

public class GrowthShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:growthshrine")
    public static final BlockEntityType<GrowthShrineBlockEntity> TYPE = null;
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = GrowthShrineBlockEntity.createKey("growthshrine");

    public GrowthShrineBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findGrowable() {
        int range = this.getIntegerRange();
        List<BlockPos> positions = IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(0, 4).mapToObj(y -> new BlockPos(this.f_58858_.m_123341_() + x, this.f_58858_.m_123342_() + y, this.f_58858_.m_123343_() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(this::canGrow).toList();
        return positions.isEmpty() ? Optional.empty() : Optional.of(positions.get(this.f_58857_.f_46441_.nextInt(positions.size())));
    }

    private boolean stemCanGrow(StemBlock stem) {
        if (this.hasUpgrade(ShrineUpgrades.STEM_POLLINATION)) {
            StemGrownBlock crop = stem.m_57056_();
            return Direction.Plane.HORIZONTAL.m_122557_().map(d -> this.f_58857_.m_8055_(this.f_58858_.m_142300_(d))).noneMatch(arg_0 -> GrowthShrineBlockEntity.lambda$stemCanGrow$6((Block)crop, arg_0));
        }
        return false;
    }

    private boolean canGrow(BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_204336_(ECTags.Blocks.GROWTHSHRINE_BLACKLIST)) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock growable = (BonemealableBlock)block;
            return growable.m_7370_((BlockGetter)this.f_58857_, pos, state, this.f_58857_.f_46443_) && (growable.m_5491_(this.f_58857_, this.f_58857_.f_46441_, pos, state) || this.hasUpgrade(ShrineUpgrades.BONELESS_GROWTH)) || block instanceof StemBlock && this.stemCanGrow((StemBlock)block);
        }
        return false;
    }

    @Override
    public AABB getRangeBoundingBox() {
        int range = this.getIntegerRange();
        return new AABB(this.m_58899_()).m_82377_((double)range, 0.0, (double)range).m_82363_(0.0, 2.0, 0.0);
    }

    @Override
    protected boolean doPeriod() {
        if (this.f_58857_ instanceof ServerLevel) {
            return this.findGrowable().map(p -> {
                BlockState blockstate = this.f_58857_.m_8055_(p);
                ((BonemealableBlock)blockstate.m_60734_()).m_7719_((ServerLevel)this.f_58857_, this.f_58857_.f_46441_, p, blockstate);
                this.f_58857_.m_46796_(2005, p, 0);
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$stemCanGrow$6(Block crop, BlockState state) {
        return state.m_60713_(crop);
    }
}

