/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.grove;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.tag.ECTags;

public class GroveShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:groveshrine")
    public static final BlockEntityType<GroveShrineBlockEntity> TYPE = null;
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = GroveShrineBlockEntity.createKey("groveshrine");
    private static final Lazy<HolderSet.Named<Item>> MYSTICAL_GROVE_FLOWERS = Lazy.of(() -> ECTags.Items.getTag(ECTags.Items.MYSTICAL_GROVE_FLOWERS));
    private static final Lazy<HolderSet.Named<Item>> GROVE_SHRINE_FLOWERS = Lazy.of(() -> ECTags.Items.getTag(ECTags.Items.GROVE_SHRINE_FLOWERS));

    public GroveShrineBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findGrass() {
        int range = this.getIntegerRange();
        List<BlockPos> positions = IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(-1, 3).mapToObj(y -> new BlockPos(this.f_58858_.m_123341_() + x, this.f_58858_.m_123342_() + y, this.f_58858_.m_123343_() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(this::canPlant).map(BlockPos::m_7494_).toList();
        return positions.isEmpty() ? Optional.empty() : Optional.of(positions.get(this.f_58857_.f_46441_.nextInt(positions.size())));
    }

    private boolean canPlant(BlockPos pos) {
        BlockPos up = pos.m_7494_();
        return this.f_58857_.m_8055_(pos).m_60734_() == Blocks.f_50440_ && this.f_58857_.m_8055_(up).m_60795_();
    }

    @Override
    public AABB getRangeBoundingBox() {
        int range = this.getIntegerRange();
        return new AABB(this.m_58899_()).m_82377_((double)range, 0.0, (double)range).m_82363_(0.0, -1.0, 0.0).m_82363_(0.0, 1.0, 0.0);
    }

    @Override
    protected boolean doPeriod() {
        if (this.f_58857_ instanceof ServerLevel) {
            return this.findGrass().map(p -> {
                BlockItem item = this.findFlower();
                item.m_40576_((BlockPlaceContext)new DirectionalPlaceContext(this.f_58857_, p, Direction.DOWN, new ItemStack((ItemLike)item), Direction.UP));
                this.f_58857_.m_46796_(2005, p, 0);
                return true;
            }).orElse(false);
        }
        return false;
    }

    private BlockItem findFlower() {
        List<BlockItem> flowers = (this.hasUpgrade(ShrineUpgrades.MYSTICAL_GROVE) ? ((HolderSet.Named)MYSTICAL_GROVE_FLOWERS.get()).m_203614_() : ((HolderSet.Named)GROVE_SHRINE_FLOWERS.get()).m_203614_().filter(item -> !item.m_203656_(ECTags.Items.GROVE_SHRINE_BLACKLIST))).map(Holder::m_203334_).mapMulti(ElementalCraftUtils.cast(BlockItem.class)).toList();
        return flowers.get(this.f_58857_.f_46441_.nextInt(flowers.size()));
    }
}

