/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.firepylon;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;

public class FirePylonBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:firepylon")
    public static final BlockEntityType<FirePylonBlockEntity> TYPE = null;
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = FirePylonBlockEntity.createKey("firepylon");
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public FirePylonBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PROPERTIES_KEY);
    }

    private List<LivingEntity> getEntities() {
        return this.m_58904_().m_6443_(LivingEntity.class, this.getRangeBoundingBox(), e -> !e.m_5833_() && !e.m_21023_(MobEffects.f_19607_) && !e.m_6060_() && !ToolInfusionHelper.hasFireInfusion((Entity)e) && (!this.hasUpgrade(ShrineUpgrades.PROTECTION) || EntityHelper.isHostile((Entity)e)));
    }

    @Override
    protected boolean doPeriod() {
        int consumeAmount = this.getConsumeAmount();
        float strength = (float)this.getStrength();
        this.getEntities().forEach(e -> {
            if (this.elementStorage.getElementAmount() >= consumeAmount) {
                e.m_6469_(DamageSource.f_19305_, strength);
                e.m_20254_((int)((float)this.consumeElement(consumeAmount) * strength));
            }
        });
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

