/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.breeding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlock;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;

public class BreedingShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:breedingshrine")
    public static final BlockEntityType<BreedingShrineBlockEntity> TYPE = null;
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = BreedingShrineBlockEntity.createKey("breedingshrine");

    public BreedingShrineBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PROPERTIES_KEY);
    }

    private <T extends Entity> List<T> getEntities(Class<T> clazz) {
        return new ArrayList(this.m_58904_().m_6443_(clazz, this.getRangeBoundingBox(), e -> !e.m_5833_()));
    }

    @Override
    public AABB getRangeBoundingBox() {
        return super.getRangeBoundingBox().m_82383_(Vec3.m_82528_((Vec3i)((Direction)this.m_58900_().m_61143_((Property)BreedingShrineBlock.FACING)).m_122436_()).m_82490_((double)this.getRange()));
    }

    @Override
    protected boolean doPeriod() {
        EntityType type = null;
        Animal first = null;
        Animal second = null;
        for (Animal entity : this.getEntities(Animal.class)) {
            if (type == null && entity.m_5957_()) {
                type = entity.m_6095_();
                first = entity;
                continue;
            }
            if (second != null || type == null || !type.equals(entity.m_6095_()) || !entity.m_5957_()) continue;
            second = entity;
        }
        if (first != null && second != null) {
            return this.feed(first, second);
        }
        return false;
    }

    public boolean consumeFood(Animal first) {
        List<ItemStack> foodList = this.getEntities(ItemEntity.class).stream().map(ItemEntity::m_32055_).filter(stack -> first.m_6898_(stack) && stack.m_41613_() > 0).toList();
        if (foodList.isEmpty()) {
            return false;
        }
        if (foodList.get(0).m_41613_() >= 2) {
            foodList.get(0).m_41774_(2);
        } else if (foodList.size() >= 2) {
            foodList.get(0).m_41774_(1);
            foodList.get(1).m_41774_(1);
        } else {
            return false;
        }
        return true;
    }

    public boolean feed(Animal first, Animal second) {
        if (!this.consumeFood(first)) {
            return false;
        }
        first.m_27601_(600);
        second.m_27601_(600);
        return true;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        BlockState state = this.m_58900_();
        return state.m_61143_(BreedingShrineBlock.PART) == BreedingShrineBlock.Part.BOWL ? Collections.emptyList() : DEFAULT_UPGRADE_DIRECTIONS.stream().filter(direction -> direction != state.m_61143_((Property)BreedingShrineBlock.FACING)).collect(Collectors.toList());
    }
}

