/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine;

import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.shrine.ShrineElementStorage;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.AbstractShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;

public abstract class AbstractShrineBlockEntity
extends AbstractECBlockEntity
implements IElementTypeProvider {
    protected static final List<Direction> DEFAULT_UPGRADE_DIRECTIONS = List.of(Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    protected final Holder<ShrineProperties> properties;
    private final Map<Direction, ShrineUpgrade> upgrades = new EnumMap<Direction, ShrineUpgrade>(Direction.class);
    private final Map<ShrineUpgrade.BonusType, Float> upgradeMultipliers = new EnumMap<ShrineUpgrade.BonusType, Float>(ShrineUpgrade.BonusType.class);
    protected final ShrineElementStorage elementStorage = new ShrineElementStorage(this);
    private boolean running = false;
    private double tick = 0.0;
    private int rangeRenderTimer = 0;

    protected AbstractShrineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, ResourceKey<ShrineProperties> upgradeKey) {
        super(blockEntityType, pos, state);
        this.properties = ElementalCraft.SHRINE_PROPERTIES_MANAGER.getOrCreateHolder(upgradeKey);
    }

    @Nonnull
    protected static ResourceKey<ShrineProperties> createKey(@Nonnull String name) {
        return IDataManager.createKey(ElementalCraft.SHRINE_PROPERTIES_MANAGER_KEY, (ResourceLocation)ElementalCraft.createRL(name));
    }

    protected int consumeElement(int i) {
        return this.elementStorage.extractElement(i, false);
    }

    protected abstract boolean doPeriod();

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractShrineBlockEntity shrine) {
        if (shrine.isDirty()) {
            shrine.refresh();
        }
        double period = shrine.getPeriod();
        int consumeAmount = shrine.getConsumeAmount();
        shrine.running = false;
        if (!shrine.isPowered()) {
            shrine.tick += 1.0;
            if (period <= 0.0) {
                ElementalCraftApi.LOGGER.warn("Shrine period should not be 0");
                period = 1.0;
            }
            while (shrine.tick >= period) {
                if (shrine.elementStorage.getElementAmount() >= consumeAmount && shrine.doPeriod()) {
                    shrine.consumeElement(consumeAmount);
                }
                shrine.tick -= period;
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AbstractShrineBlockEntity shrine) {
        if (shrine.rangeRenderTimer > 0) {
            --shrine.rangeRenderTimer;
        }
    }

    public void refresh() {
        if (!this.m_58898_()) {
            return;
        }
        this.elementStorage.refresh();
        this.upgrades.clear();
        this.upgradeMultipliers.clear();
        this.getUpgradeDirections().forEach(direction -> {
            ShrineUpgrade upgrade;
            AbstractShrineUpgradeBlock upgradeBlock;
            BlockPos pos = this.m_58899_().m_142300_(direction);
            BlockState state = this.m_58904_().m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof AbstractShrineUpgradeBlock && (upgradeBlock = (AbstractShrineUpgradeBlock)block).getFacing(state) == direction.m_122424_() && (upgrade = upgradeBlock.getUpgrade()) != null) {
                this.setUpgrade((Direction)direction, upgrade);
            }
        });
        this.getUpgradeDirections().forEach(direction -> {
            BlockPos pos = this.m_58899_().m_142300_(direction);
            BlockState state = this.m_58904_().m_8055_(pos);
            if (!state.m_60710_((LevelReader)this.f_58857_, pos)) {
                this.f_58857_.m_46961_(pos, true);
            }
        });
    }

    protected float getMultiplier(ShrineUpgrade.BonusType type) {
        return this.upgradeMultipliers.getOrDefault((Object)type, Float.valueOf(1.0f)).floatValue();
    }

    public int getUpgradeCount(ShrineUpgrade upgrade) {
        return upgrade == null ? 0 : (int)this.upgrades.values().stream().filter(upgrade::equals).count();
    }

    public int getUpgradeCount(ResourceKey<ShrineUpgrade> key) {
        return key == null ? 0 : (int)this.upgrades.values().stream().filter(u -> u.is(key)).count();
    }

    public boolean hasUpgrade(ShrineUpgrade upgrade) {
        return this.getUpgradeCount(upgrade) > 0;
    }

    public boolean hasUpgrade(ResourceKey<ShrineUpgrade> key) {
        return this.getUpgradeCount(key) > 0;
    }

    private void setUpgrade(Direction direction, ShrineUpgrade upgrade) {
        ShrineUpgrade old = this.upgrades.get(direction);
        if (old != null) {
            old.getBonuses().forEach((type, bonus) -> this.upgradeMultipliers.put((ShrineUpgrade.BonusType)((Object)type), Float.valueOf(this.getMultiplier((ShrineUpgrade.BonusType)((Object)type)) / bonus.floatValue())));
        }
        this.upgrades.put(direction, upgrade);
        upgrade.getBonuses().forEach((type, bonus) -> this.upgradeMultipliers.put((ShrineUpgrade.BonusType)((Object)type), Float.valueOf(this.getMultiplier((ShrineUpgrade.BonusType)((Object)type)) * bonus.floatValue())));
    }

    public Collection<ShrineUpgrade> getAllUpgrades() {
        return this.upgrades.values();
    }

    public List<Direction> getUpgradeDirections() {
        return DEFAULT_UPGRADE_DIRECTIONS;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean showsRange() {
        return this.rangeRenderTimer > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startShowingRange() {
        this.rangeRenderTimer = 600;
    }

    public AABB getRangeBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_((double)this.getRange());
    }

    @Override
    public ElementType getElementType() {
        return this.getProperties().getElementType();
    }

    public float getRange() {
        return this.getProperties().range() * this.getMultiplier(ShrineUpgrade.BonusType.RANGE);
    }

    public int getIntegerRange() {
        return Math.round(this.getRange());
    }

    public int getConsumeAmount() {
        return Math.round((float)this.getProperties().consumption() * this.getMultiplier(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION));
    }

    public double getPeriod() {
        return this.getProperties().period() * (double)this.getMultiplier(ShrineUpgrade.BonusType.SPEED);
    }

    @Nonnull
    public ShrineProperties getProperties() {
        if (this.properties.m_203633_()) {
            return (ShrineProperties)this.properties.m_203334_();
        }
        return ShrineProperties.DEFAULT;
    }

    public int getCapacity() {
        return Math.round((float)this.getProperties().capacity() * this.getMultiplier(ShrineUpgrade.BonusType.CAPACITY));
    }

    public double getStrength() {
        return this.getStrength(0);
    }

    public double getStrength(int index) {
        Double value = this.getProperties().strength().get(index);
        return (value != null ? value : 1.0) * (double)this.getMultiplier(ShrineUpgrade.BonusType.STRENGTH);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("element_storage")) {
            this.elementStorage.deserializeNBT(compound.m_128469_("element_storage"));
        }
        this.running = compound.m_128471_("running");
        this.refresh();
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("element_storage", (Tag)this.elementStorage.serializeNBT());
        compound.m_128379_("running", this.running);
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
        }
        return super.getCapability(cap, side);
    }

    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }
}

