/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.retriever;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.property.ECProperties;

public class RetrieverBlock
extends Block
implements ISorterBlock {
    public static final String NAME = "instrument_retriever";
    private static final VoxelShape CORE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public RetrieverBlock() {
        super(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SOURCE, (Comparable)Direction.SOUTH)).m_61124_((Property)TARGET, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)SOURCE, (Comparable)direction.m_122424_())).m_61124_((Property)TARGET, (Comparable)direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{SOURCE, TARGET});
    }

    @Override
    public VoxelShape getCoreShape(BlockState state) {
        return CORE;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return worldIn instanceof Level && ((Level)worldIn).f_46443_ ? this.getShape(state, pos, Minecraft.m_91087_().f_91077_) : this.getCurentShape(state);
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getCurentShape(state);
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        return this.moveIO(state, world, pos, hit);
    }

    public static void sendOutputToRetriever(Level world, BlockPos pos, Container inventory, int slot) {
        ItemStack stack = inventory.m_8020_(slot);
        if (!world.m_46753_(pos) && !stack.m_41619_()) {
            for (Direction direction : Direction.values()) {
                BlockPos retrieverPos = pos.m_142300_(direction);
                BlockState blockState = world.m_8055_(retrieverPos);
                if (!(blockState.m_60734_() instanceof RetrieverBlock) || blockState.m_61143_((Property)SOURCE) != direction.m_122424_()) continue;
                stack = RetrieverBlock.retrieve(blockState, (BlockGetter)world, retrieverPos, stack);
                inventory.m_6836_(slot, stack);
                if (!stack.m_41619_()) continue;
                return;
            }
        }
    }

    public static ItemStack retrieve(BlockState state, BlockGetter world, BlockPos pos, ItemStack output) {
        Direction direction = (Direction)state.m_61143_((Property)TARGET);
        return ItemHandlerHelper.insertItem((IItemHandler)ECContainerHelper.getItemHandlerAt(world, pos.m_142300_(direction), direction.m_122424_()), (ItemStack)output, (boolean)false);
    }
}

