/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser.pedestal;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractIERBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalElementStorage;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleItemContainer;

public class PedestalBlockEntity
extends AbstractIERBlockEntity
implements IElementTypeProvider {
    @ObjectHolder(value="elementalcraft:pedestal")
    public static final BlockEntityType<PedestalBlockEntity> TYPE = null;
    private final SingleItemContainer inventory = new SingleItemContainer(this::m_6596_);
    private final SingleElementStorage elementStorage;
    private final RuneHandler runeHandler;

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.elementStorage = new PedestalElementStorage(ElementType.getElementType(state), this::m_6596_);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.pedestalMaxRunes.get(), this::m_6596_);
    }

    public Direction getPureInfuserDirection() {
        return Stream.of(Direction.values()).filter(d -> d.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL).filter(d -> this.m_58904_().m_7702_(this.f_58858_.m_5484_(d, 3)) instanceof PureInfuserBlockEntity).findAny().orElse(Direction.UP);
    }

    @Override
    public ElementType getElementType() {
        return this.elementStorage.getElementType();
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.m_8020_(0);
    }

    @Override
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Override
    @Nonnull
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }
}

