/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.BooleanUtils;
import sirttas.elementalcraft.api.clinet.renderer.ECRenderTypes;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.renderer.SingleItemRenderer;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.event.TickHandler;

public class PureInfuserRenderer
extends SingleItemRenderer<PureInfuserBlockEntity> {
    public PureInfuserRenderer() {
        super(new Vec3(0.5, 0.9, 0.5));
    }

    public void render(@Nonnull PureInfuserBlockEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Map<Direction, ElementType> map;
        List<ElementType> remaining;
        if (BooleanUtils.isTrue((Boolean)((Boolean)ECConfig.CLIENT.renderPedestalShadow.get())) && !te.isRunning() && !(remaining = this.getRemainingElements(map = this.getDirectionMap(te))).isEmpty()) {
            map.entrySet().stream().filter(entry -> entry.getValue() == ElementType.NONE).map(Map.Entry::getKey).forEach(direction -> {
                ElementType type = (ElementType)remaining.get((int)(((float)TickHandler.getTicksInGame() + partialTicks) / 20.0f % (float)remaining.size()));
                Block pedestal = this.getPedestalForType(type);
                if (pedestal != null) {
                    matrixStack.m_85836_();
                    matrixStack.m_85837_((double)direction.m_122429_() * 3.0, 0.0, (double)direction.m_122431_() * 3.0);
                    this.renderBlock(pedestal.m_49966_(), matrixStack, buffer.m_6299_(ECRenderTypes.GHOST), te.m_58904_(), te.m_58899_().m_5484_(direction, 3));
                    matrixStack.m_85849_();
                    remaining.remove(type);
                }
            });
        }
        super.m_6922_(te, partialTicks, matrixStack, buffer, light, overlay);
    }

    private List<ElementType> getRemainingElements(Map<Direction, ElementType> map) {
        List<ElementType> usedElements = map.values().stream().filter(elementType -> elementType != ElementType.NONE).toList();
        return ElementType.ALL_VALID.stream().filter(type -> !usedElements.contains(type)).collect(Collectors.toList());
    }

    private Map<Direction, ElementType> getDirectionMap(PureInfuserBlockEntity te) {
        EnumMap<Direction, ElementType> map = new EnumMap<Direction, ElementType>(Direction.class);
        map.put(Direction.NORTH, this.getPedestal(te, Direction.NORTH));
        map.put(Direction.SOUTH, this.getPedestal(te, Direction.SOUTH));
        map.put(Direction.WEST, this.getPedestal(te, Direction.WEST));
        map.put(Direction.EAST, this.getPedestal(te, Direction.EAST));
        return map;
    }

    private ElementType getPedestal(PureInfuserBlockEntity te, Direction direction) {
        BlockState state = te.m_58904_().m_8055_(te.m_58899_().m_5484_(direction, 3));
        Block block = state.m_60734_();
        return block instanceof PedestalBlock ? ((PedestalBlock)block).getElementType() : ElementType.NONE;
    }

    private Block getPedestalForType(ElementType type) {
        return switch (type) {
            case ElementType.WATER -> ECBlocks.WATER_PEDESTAL;
            case ElementType.FIRE -> ECBlocks.FIRE_PEDESTAL;
            case ElementType.EARTH -> ECBlocks.EARTH_PEDESTAL;
            case ElementType.AIR -> ECBlocks.AIR_PEDESTAL;
            default -> null;
        };
    }
}

