/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleItemContainer;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;

public class PureInfuserBlockEntity
extends AbstractECCraftingBlockEntity<PureInfuserBlockEntity, PureInfusionRecipe> {
    @ObjectHolder(value="elementalcraft:pureinfuser")
    public static final BlockEntityType<PureInfuserBlockEntity> TYPE = null;
    private final SingleItemContainer inventory;
    private final Map<Direction, Integer> progress = new EnumMap<Direction, Integer>(Direction.class);
    private final RuneHandler runeHandler;

    public PureInfuserBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, PureInfusionRecipe.TYPE, (Integer)ECConfig.COMMON.pureInfuserTransferSpeed.get());
        this.inventory = new SingleItemContainer(this::m_6596_);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.pureInfuserMaxRunes.get(), this::m_6596_);
        this.progress.put(Direction.NORTH, 0);
        this.progress.put(Direction.SOUTH, 0);
        this.progress.put(Direction.WEST, 0);
        this.progress.put(Direction.EAST, 0);
    }

    @Override
    public void process() {
        super.process();
        if (this.f_58857_.f_46443_) {
            ParticleHelper.createCraftingParticle(ElementType.NONE, this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, 0.7, 0.0), this.f_58857_.f_46441_);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PureInfuserBlockEntity pureInfuser) {
        if (!pureInfuser.isPowered()) {
            pureInfuser.makeProgress();
        }
    }

    protected void makeProgress() {
        if (this.recipe != null && this.getProgress(Direction.NORTH) >= ((PureInfusionRecipe)this.recipe).getElementAmount() && this.getProgress(Direction.SOUTH) >= ((PureInfusionRecipe)this.recipe).getElementAmount() && this.getProgress(Direction.WEST) >= ((PureInfusionRecipe)this.recipe).getElementAmount() && this.getProgress(Direction.EAST) >= ((PureInfusionRecipe)this.recipe).getElementAmount()) {
            this.process();
            this.progress.clear();
        } else if (this.isRecipeAvailable()) {
            this.makeProgress(Direction.NORTH);
            this.makeProgress(Direction.SOUTH);
            this.makeProgress(Direction.WEST);
            this.makeProgress(Direction.EAST);
        } else if (this.recipe == null) {
            this.progress.clear();
        }
    }

    public ItemStack getStackInPedestal(ElementType type) {
        PedestalBlockEntity pedestal = this.getPedestal(type);
        return pedestal != null ? pedestal.getItem() : ItemStack.f_41583_;
    }

    public PedestalBlockEntity getPedestal(ElementType type) {
        PedestalBlockEntity pedestal = this.getPedestal(Direction.NORTH);
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.SOUTH);
        }
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.WEST);
        }
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.EAST);
        }
        return pedestal != null && pedestal.getElementType() == type ? pedestal : null;
    }

    public void emptyPedestals() {
        this.setPedestalInventory(Direction.NORTH, ItemStack.f_41583_);
        this.setPedestalInventory(Direction.SOUTH, ItemStack.f_41583_);
        this.setPedestalInventory(Direction.WEST, ItemStack.f_41583_);
        this.setPedestalInventory(Direction.EAST, ItemStack.f_41583_);
    }

    private void setPedestalInventory(Direction direction, ItemStack stack) {
        PedestalBlockEntity pedestal = this.getPedestal(direction);
        if (pedestal != null) {
            pedestal.getInventory().m_6836_(0, stack);
            pedestal.m_6596_();
        }
    }

    private PedestalBlockEntity getPedestal(Direction direction) {
        BlockEntity te = this.f_58857_ != null ? this.f_58857_.m_7702_(this.f_58858_.m_5484_(direction, 3)) : null;
        return te instanceof PedestalBlockEntity ? (PedestalBlockEntity)te : null;
    }

    private void makeProgress(Direction direction) {
        float transferAmount;
        PedestalBlockEntity pedestal = this.getPedestal(direction);
        Direction offset = direction.m_122424_();
        int oldProgress = this.getProgress(direction);
        if (pedestal != null && (transferAmount = Math.min(this.getTransferSpeed(pedestal), (float)((PureInfusionRecipe)this.recipe).getElementAmount() - (float)oldProgress)) > 0.0f) {
            float preservation = this.runeHandler.getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + pedestal.getRuneHandler().getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + 1.0f;
            float newProgress = (float)oldProgress + (float)pedestal.getElementStorage().extractElement(Math.round(transferAmount / preservation), false) * preservation;
            this.progress.put(direction, Math.round(newProgress));
            if (this.f_58857_ != null && this.f_58857_.f_46443_ && newProgress > 0.0f && this.getProgressRounded(transferAmount, newProgress) > this.getProgressRounded(transferAmount, oldProgress)) {
                ParticleHelper.createElementFlowParticle(pedestal.getElementType(), this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, 0.7, 0.0), offset, 2.5f, this.f_58857_.f_46441_);
            }
        }
    }

    @Override
    public void assemble() {
        this.inventory.m_6836_(0, ((PureInfusionRecipe)this.recipe).assemble(this));
        this.emptyPedestals();
    }

    private float getTransferSpeed(PedestalBlockEntity pedestal) {
        return (float)this.transferSpeed * (this.runeHandler.getBonus(Rune.BonusType.SPEED) + pedestal.getRuneHandler().getBonus(Rune.BonusType.SPEED) + 1.0f);
    }

    public int getProgress(Direction direction) {
        return this.progress.getOrDefault(direction, 0);
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.m_8020_(0);
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public boolean isRunning() {
        return this.progress.values().stream().anyMatch(i -> i > 0);
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        int[] progressArray = compound.m_128465_("progress");
        for (int i = 0; i < progressArray.length; ++i) {
            this.progress.put(Direction.m_122407_((int)i), progressArray[i]);
        }
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128385_("progress", this.progress.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Direction)e.getKey()).m_122416_())).mapToInt(Map.Entry::getValue).toArray());
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

