/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;

public class ElementPipeTransferer
implements IElementTransferer {
    final BlockEntity pipe;
    final Map<Direction, IElementTransferer.ConnectionType> connections;
    final Map<Direction, Boolean> priorities;
    final Comparator<Map.Entry<Direction, IElementTransferer.ConnectionType>> comparator;
    final int maxTransferAmount;
    int transferedAmount;

    ElementPipeTransferer(BlockEntity pipe) {
        this.pipe = pipe;
        this.connections = new EnumMap<Direction, IElementTransferer.ConnectionType>(Direction.class);
        this.priorities = new EnumMap<Direction, Boolean>(Direction.class);
        this.comparator = this.creatComparator();
        this.maxTransferAmount = ((ElementPipeBlock)pipe.m_58900_().m_60734_()).getMaxTransferAmount();
    }

    private Comparator<Map.Entry<Direction, IElementTransferer.ConnectionType>> creatComparator() {
        Comparator cmp = (c1, c2) -> Boolean.compare(this.isPriority((Direction)c2.getKey()), this.isPriority((Direction)c1.getKey()));
        return cmp.thenComparing((c1, c2) -> ((IElementTransferer.ConnectionType)((Object)((Object)c2.getValue()))).getValue() - ((IElementTransferer.ConnectionType)((Object)((Object)c1.getValue()))).getValue());
    }

    public boolean isPriority(Direction face) {
        return Boolean.TRUE.equals(this.priorities.get(face));
    }

    @Override
    public IElementTransferer.ConnectionType getConnection(Direction face) {
        return this.connections.getOrDefault(face, IElementTransferer.ConnectionType.NONE);
    }

    @Override
    public Map<Direction, IElementTransferer.ConnectionType> getConnections() {
        return this.connections;
    }

    @Override
    public Stream<Map.Entry<Direction, IElementTransferer.ConnectionType>> getConnectionStream() {
        return this.connections.entrySet().stream().filter(entry -> {
            IElementTransferer.ConnectionType connection = (IElementTransferer.ConnectionType)((Object)((Object)entry.getValue()));
            return connection == IElementTransferer.ConnectionType.CONNECT || connection == IElementTransferer.ConnectionType.INSERT;
        }).sorted(this.comparator);
    }

    @Override
    public int getRemainingTransferAmount() {
        return this.maxTransferAmount - this.transferedAmount;
    }

    @Override
    public void transfer(int amount) {
        this.transferedAmount += amount;
    }

    @Override
    public boolean isValid() {
        return this.transferedAmount < this.maxTransferAmount && !this.pipe.m_58901_();
    }

    void setConnection(Direction face, IElementTransferer.ConnectionType type) {
        this.connections.put(face, type);
        if (!type.isConnected() && this.isPriority(face)) {
            this.setPriority(face, false);
        }
    }

    void setPriority(Direction face, boolean value) {
        this.priorities.put(face, value);
    }

    void resetTransferedAmount() {
        this.transferedAmount = 0;
    }

    void load(CompoundTag compound) {
        for (Direction face : Direction.values()) {
            this.setConnection(face, IElementTransferer.ConnectionType.fromInteger(compound.m_128451_(face.m_7912_())));
            this.setPriority(face, compound.m_128471_(face.m_7912_() + "_priority"));
        }
    }

    CompoundTag save(CompoundTag compound) {
        this.connections.forEach((k, v) -> compound.m_128405_(k.m_7912_(), v.getValue()));
        this.priorities.forEach((k, v) -> compound.m_128379_(k.m_7912_() + "_priority", v.booleanValue()));
        return compound;
    }
}

