/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.block.entity.renderer.IECRenderer;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;

public class ElementPipeRenderer
implements IECRenderer<ElementPipeBlockEntity> {
    public static final ResourceLocation SIDE_LOCATION = ElementalCraft.createRL("block/elementpipe_side");
    public static final ResourceLocation EXTRACT_LOCATION = ElementalCraft.createRL("block/elementpipe_extract");
    public static final ResourceLocation PRIORITY_LOCATION = ElementalCraft.createRL("block/elementpipe_priority");
    private static final AABB BOX = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private BakedModel sideModel;
    private BakedModel extractModel;
    private BakedModel priorityModel;

    public void render(ElementPipeBlockEntity te, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        boolean showCover;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        Level level = Objects.requireNonNull(te.m_58904_());
        BlockState coverState = te.getCoverState();
        boolean bl = showCover = coverState != null && !coverState.m_60795_();
        if (this.sideModel == null || this.extractModel == null || this.priorityModel == null) {
            ModelManager modelManager = minecraft.m_91304_();
            this.sideModel = modelManager.getModel(SIDE_LOCATION);
            this.extractModel = modelManager.getModel(EXTRACT_LOCATION);
            this.priorityModel = modelManager.getModel(PRIORITY_LOCATION);
        }
        if (showCover && ElementPipeBlock.showCover(te.m_58900_(), (Player)player)) {
            this.renderBlock(coverState, poseStack, buffer, light, overlay, this.getModelData(level, te.m_58899_()));
        } else {
            this.renderPipes(te, poseStack, buffer, light, overlay);
            if (showCover) {
                this.renderBlock((BlockState)te.m_58900_().m_61124_(ElementPipeBlock.COVER, (Comparable)((Object)ElementPipeBlock.CoverType.NONE)), poseStack, buffer, light, overlay, this.getModelData(level, te.m_58899_()));
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (AABB)BOX, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    private void renderPipes(ElementPipeBlockEntity te, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        Stream.of(Direction.values()).forEach(d -> this.renderSide(te, (Direction)d, matrixStack, buffer, light, overlay));
        matrixStack.m_85849_();
    }

    private void renderSide(ElementPipeBlockEntity te, Direction side, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        IElementTransferer.ConnectionType connection = te.getConnection(side);
        if (connection.isConnected()) {
            matrixStack.m_85836_();
            matrixStack.m_85845_(side.m_122406_());
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            this.renderModel(this.sideModel, matrixStack, buffer, te, light, overlay);
            if (connection == IElementTransferer.ConnectionType.EXTRACT) {
                this.renderModel(this.extractModel, matrixStack, buffer, te, light, overlay);
            }
            if (te.isPriority(side)) {
                this.renderModel(this.priorityModel, matrixStack, buffer, te, light, overlay);
            }
            matrixStack.m_85849_();
        }
    }
}

