/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.CapabilityElementTransferer;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.api.element.transfer.path.SimpleElementTransferPathfinder;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;
import sirttas.elementalcraft.item.ECItems;

public class ElementPipeBlockEntity
extends AbstractECBlockEntity {
    @ObjectHolder(value="elementalcraft:elementpipe")
    public static final BlockEntityType<ElementPipeBlockEntity> TYPE = null;
    private final ElementPipeTransferer transferer = new ElementPipeTransferer(this);
    private BlockState coverState;
    private SimpleElementTransferPathfinder pathfinder;
    private final Map<Direction, IElementTransferPath> pathMap = new EnumMap<Direction, IElementTransferPath>(Direction.class);

    public ElementPipeBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    private Optional<BlockEntity> getAdjacentTile(Direction face) {
        return this.m_58898_() ? BlockEntityHelper.getBlockEntity((BlockGetter)this.m_58904_(), this.m_58899_().m_142300_(face)) : Optional.empty();
    }

    public IElementTransferer.ConnectionType getConnection(Direction face) {
        return this.transferer.getConnection(face);
    }

    public boolean isPriority(Direction face) {
        return this.transferer.isPriority(face);
    }

    private void setConnection(Direction face, IElementTransferer.ConnectionType type) {
        if (this.transferer.getConnection(face) == type) {
            return;
        }
        this.transferer.setConnection(face, type);
        if (!type.isConnected() && this.isPriority(face)) {
            this.setPriority(face, false);
            this.dropPriorities(null, 1);
        }
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.m_58900_().m_60701_((LevelAccessor)this.f_58857_, this.m_58899_(), 1);
        }
    }

    private void setPriority(Direction face, boolean value) {
        this.transferer.setPriority(face, value);
        this.m_6596_();
    }

    private void refresh(Direction face) {
        Direction opposite = face.m_122424_();
        this.setConnection(face, this.getAdjacentTile(face).map(tile -> {
            IElementTransferer.ConnectionType connection = this.getConnection(face);
            if (connection != IElementTransferer.ConnectionType.NONE) {
                return connection;
            }
            if (tile instanceof ElementPipeBlockEntity) {
                return IElementTransferer.ConnectionType.CONNECT;
            }
            return CapabilityElementStorage.get((ICapabilityProvider)tile, opposite).map(storage -> {
                if (this.canInsertInStorage((IElementStorage)storage, opposite)) {
                    return IElementTransferer.ConnectionType.INSERT;
                }
                if (this.canExtractFromStorage((IElementStorage)storage, opposite)) {
                    return IElementTransferer.ConnectionType.EXTRACT;
                }
                return IElementTransferer.ConnectionType.NONE;
            }).orElse(IElementTransferer.ConnectionType.NONE);
        }).orElse(IElementTransferer.ConnectionType.NONE));
    }

    void refresh() {
        for (Direction face : Direction.values()) {
            this.refresh(face);
        }
    }

    Map<Direction, IElementTransferPath> getPathMap() {
        return this.pathMap;
    }

    private void transferElement(IElementStorage sender, Direction side, ElementType type) {
        if (type != ElementType.NONE && this.pathfinder != null) {
            IElementTransferPath path = this.pathfinder.findPath(type, sender, this.transferer, this.m_58899_());
            this.pathMap.put(side, path);
            path.transfer();
        }
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, ElementPipeBlockEntity pipe) {
        pipe.refresh();
        pipe.transferer.resetTransferedAmount();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ElementPipeBlockEntity pipe) {
        ElementPipeBlockEntity.commonTick(level, pos, state, pipe);
        if (pipe.pathfinder == null) {
            pipe.pathfinder = new SimpleElementTransferPathfinder(level);
        }
        pipe.transferer.getConnections().entrySet().stream().filter(entry -> entry.getValue() == IElementTransferer.ConnectionType.EXTRACT).sorted(pipe.transferer.comparator).map(Map.Entry::getKey).forEach(side -> pipe.getAdjacentTile((Direction)side).flatMap(tile -> CapabilityElementStorage.get((ICapabilityProvider)tile, side.m_122424_()).resolve()).ifPresent(sender -> {
            if (sender instanceof IElementTypeProvider) {
                IElementTypeProvider provider = (IElementTypeProvider)((Object)sender);
                pipe.transferElement((IElementStorage)sender, (Direction)side, provider.getElementType());
            }
        }));
    }

    public InteractionResult activatePriority(Direction face, Player player, InteractionHand hand) {
        boolean priority = this.isPriority(face);
        this.setPriority(face, !priority);
        if (priority) {
            this.dropPriorities(player, 1);
        } else {
            ItemStack stack = player.m_21120_(hand);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void dropPriorities(@Nullable Player player, int size) {
        Level world = this.m_58904_();
        if (world != null && !world.f_46443_) {
            Vec3 vect = player != null ? player.m_20182_().m_82520_(0.0, 0.25, 0.0) : Vec3.m_82512_((Vec3i)this.m_58899_());
            world.m_7967_((Entity)new ItemEntity(world, vect.f_82479_, vect.f_82480_, vect.f_82481_, new ItemStack((ItemLike)ECItems.PIPE_PRIORITY, size)));
        }
    }

    void dropAllPriorities() {
        this.dropPriorities(null, (int)this.transferer.priorities.values().stream().filter(Boolean.TRUE::equals).count());
    }

    public InteractionResult activatePipe(Direction face) {
        Direction opposite = face.m_122424_();
        return this.getAdjacentTile(face).map(tile -> {
            IElementTransferer.ConnectionType connection = this.getConnection(face);
            switch (connection) {
                case INSERT: {
                    if (CapabilityElementStorage.get((ICapabilityProvider)tile, opposite).filter(storage -> this.canExtractFromStorage((IElementStorage)storage, opposite)).isPresent()) {
                        this.setConnection(face, IElementTransferer.ConnectionType.EXTRACT);
                    } else {
                        this.setConnection(face, IElementTransferer.ConnectionType.DISCONNECT);
                    }
                    return InteractionResult.SUCCESS;
                }
                case EXTRACT: 
                case CONNECT: {
                    this.setConnection(face, IElementTransferer.ConnectionType.DISCONNECT);
                    if (tile instanceof ElementPipeBlockEntity) {
                        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)((Object)tile);
                        pipe.setConnection(face.m_122424_(), IElementTransferer.ConnectionType.DISCONNECT);
                    }
                    return InteractionResult.SUCCESS;
                }
                case DISCONNECT: {
                    LazyOptional<IElementStorage> cap = CapabilityElementStorage.get((ICapabilityProvider)tile, face.m_122424_());
                    if (cap.filter(storage -> this.canInsertInStorage((IElementStorage)storage, opposite)).isPresent()) {
                        this.setConnection(face, IElementTransferer.ConnectionType.INSERT);
                    } else if (cap.filter(storage -> this.canExtractFromStorage((IElementStorage)storage, opposite)).isPresent()) {
                        this.setConnection(face, IElementTransferer.ConnectionType.EXTRACT);
                    } else if (tile instanceof ElementPipeBlockEntity) {
                        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)((Object)tile);
                        this.setConnection(face, IElementTransferer.ConnectionType.CONNECT);
                        pipe.setConnection(face.m_122424_(), IElementTransferer.ConnectionType.CONNECT);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    private boolean canInsertInStorage(IElementStorage storage, Direction face) {
        return ElementType.ALL_VALID.stream().anyMatch(type -> storage.canPipeInsert((ElementType)type, face));
    }

    private boolean canExtractFromStorage(IElementStorage storage, Direction face) {
        return ElementType.ALL_VALID.stream().anyMatch(type -> storage.canPipeExtract((ElementType)type, face));
    }

    public Component getConnectionMessage(Direction face) {
        return this.getConnection(face).getDisplayName();
    }

    public BlockState getCoverState() {
        return this.coverState;
    }

    public InteractionResult setCover(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockState state;
            BlockItem blockItem = (BlockItem)item;
            if (!stack.m_41619_() && (state = blockItem.m_40614_().m_49966_()) != this.coverState) {
                if (this.coverState != null) {
                    Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)new ItemStack((ItemLike)this.coverState.m_60734_()));
                }
                this.coverState = state;
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.f_58858_).m_61124_(ElementPipeBlock.COVER, (Comparable)((Object)ElementPipeBlock.CoverType.COVERED)));
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        player.m_21008_(hand, ItemStack.f_41583_);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.transferer.load(compound.m_128469_("transferer"));
        this.coverState = compound.m_128441_("cover") ? NbtUtils.m_129241_((CompoundTag)compound.m_128469_("cover")) : null;
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("transferer", (Tag)this.transferer.save(new CompoundTag()));
        if (this.coverState != null) {
            compound.m_128365_("cover", (Tag)NbtUtils.m_129202_((BlockState)this.coverState));
        } else if (compound.m_128441_("cover")) {
            compound.m_128473_("cover");
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityElementTransferer.ELEMENT_TRANSFERER_CAPABILITY) {
            return LazyOptional.of(() -> this.transferer);
        }
        return super.getCapability(cap, side);
    }
}

