/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.tag.ECTags;

public class ElementPipeBlock
extends AbstractECEntityBlock {
    public static final String NAME = "elementpipe";
    public static final String NAME_IMPAIRED = "elementpipe_impaired";
    public static final String NAME_IMPROVED = "elementpipe_improved";
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)6.5, (double)9.0, (double)9.0);
    private static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.5, (double)9.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)6.5);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)9.5, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape UP_SHAPE = Block.m_49796_((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)9.5, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape FRAME_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0)}), (BooleanOp)BooleanOp.f_82685_);
    private static final List<VoxelShape> SHAPES = List.of(EAST_SHAPE, NORTH_SHAPE, WEST_SHAPE, SOUTH_SHAPE, UP_SHAPE, DOWN_SHAPE, BASE_SHAPE, FRAME_SHAPE);
    public static final EnumProperty<CoverType> COVER = EnumProperty.m_61587_((String)"cover", CoverType.class);
    private final int maxTransferAmount;

    public ElementPipeBlock(int maxTransferAmount) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60955_().m_60977_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(COVER, (Comparable)((Object)CoverType.NONE)));
        this.maxTransferAmount = maxTransferAmount;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{COVER});
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ElementPipeBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return ElementPipeBlock.createECTicker(level, type, ElementPipeBlockEntity.TYPE, level.f_46443_ ? ElementPipeBlockEntity::commonTick : ElementPipeBlockEntity::serverTick);
    }

    @Deprecated
    public void m_6807_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ElementPipeBlockEntity) {
            ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)blockEntity;
            pipe.refresh();
        }
    }

    @Deprecated
    public void m_7458_(@NotNull BlockState state, ServerLevel worldIn, @NotNull BlockPos pos, @NotNull Random rand) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ElementPipeBlockEntity) {
            ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)blockEntity;
            pipe.refresh();
        }
    }

    private boolean compareShapes(VoxelShape shape1, VoxelShape shape2) {
        return shape1.m_83215_().equals((Object)shape2.m_83215_());
    }

    private Direction getFace(VoxelShape shape, BlockHitResult hit) {
        if (this.compareShapes(shape, DOWN_SHAPE)) {
            return Direction.DOWN;
        }
        if (this.compareShapes(shape, UP_SHAPE)) {
            return Direction.UP;
        }
        if (this.compareShapes(shape, NORTH_SHAPE)) {
            return Direction.NORTH;
        }
        if (this.compareShapes(shape, SOUTH_SHAPE)) {
            return Direction.SOUTH;
        }
        if (this.compareShapes(shape, WEST_SHAPE)) {
            return Direction.WEST;
        }
        if (this.compareShapes(shape, EAST_SHAPE)) {
            return Direction.EAST;
        }
        if (shape == BASE_SHAPE) {
            return hit.m_82434_();
        }
        return null;
    }

    public static boolean showCover(BlockState state, Player player) {
        return ElementPipeBlock.isCovered(state) && (player == null || EntityHelper.handStream(player).noneMatch(stack -> !stack.m_41619_() && stack.m_204117_(ECTags.Items.PIPE_COVER_HIDING)));
    }

    private static boolean isCovered(BlockState state) {
        return state.m_61143_(COVER) == CoverType.COVERED;
    }

    private boolean isRendered(VoxelShape shape, ElementPipeBlockEntity entity, BlockState state) {
        return state.m_60713_((Block)this) && entity != null && (this.compareShapes(shape, BASE_SHAPE) || this.compareShapes(shape, DOWN_SHAPE) && entity.getConnection(Direction.DOWN).isConnected() || this.compareShapes(shape, UP_SHAPE) && entity.getConnection(Direction.UP).isConnected() || this.compareShapes(shape, NORTH_SHAPE) && entity.getConnection(Direction.NORTH).isConnected() || this.compareShapes(shape, SOUTH_SHAPE) && entity.getConnection(Direction.SOUTH).isConnected() || this.compareShapes(shape, WEST_SHAPE) && entity.getConnection(Direction.WEST).isConnected() || this.compareShapes(shape, EAST_SHAPE) && entity.getConnection(Direction.EAST).isConnected() || this.compareShapes(shape, FRAME_SHAPE) && state.m_61143_(COVER) == CoverType.FRAME);
    }

    private VoxelShape getCurrentShape(BlockState state, ElementPipeBlockEntity entity, Player player) {
        VoxelShape result = Shapes.m_83040_();
        if (ElementPipeBlock.showCover(state, (Player)(entity != null ? player : null))) {
            return Shapes.m_83144_();
        }
        for (VoxelShape shape : SHAPES) {
            if (!this.isRendered(shape, entity, state)) continue;
            result = Shapes.m_83110_((VoxelShape)result, (VoxelShape)shape);
        }
        return result;
    }

    @Override
    @Nonnull
    @Deprecated
    public RenderShape m_7514_(@Nonnull BlockState state) {
        if (ElementPipeBlock.isCovered(state)) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return super.m_7514_(state);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Player player = this.getPlayer(context);
        ElementPipeBlockEntity blockEntity = ElementPipeBlock.getBlockEntity(world, pos);
        if (world instanceof Level) {
            Level level = (Level)world;
            if (level.f_46443_) {
                voxelShape = this.getShape(state, pos, blockEntity, Minecraft.m_91087_().f_91077_, player);
                return voxelShape;
            }
        }
        voxelShape = this.getCurrentShape(state, blockEntity, player);
        return voxelShape;
    }

    private Player getPlayer(CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockPos pos, ElementPipeBlockEntity blockEntity, HitResult result, Player player) {
        if (!ElementPipeBlock.showCover(state, player) && result != null && result.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)result).m_82425_().equals((Object)pos)) {
            Vec3 hit = result.m_82450_();
            for (VoxelShape shape : SHAPES) {
                if (!this.isRendered(shape, blockEntity, state) || !ShapeHelper.vectorCollideWithShape(shape, pos, hit)) continue;
                return shape;
            }
        }
        return this.getCurrentShape(state, blockEntity, player);
    }

    @Deprecated
    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getCurrentShape(state, ElementPipeBlock.getBlockEntity(world, pos), null);
    }

    @Deprecated
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)level.m_7702_(pos);
        if (pipe != null) {
            VoxelShape shape = this.getShape(state, pos, ElementPipeBlock.getBlockEntity((BlockGetter)level, pos), (HitResult)hit, player);
            if (this.compareShapes(shape, FRAME_SHAPE) || state.m_61143_(COVER) == CoverType.FRAME) {
                return pipe.setCover(player, hand);
            }
            Direction face = this.getFace(shape, hit);
            InteractionResult value = this.onShapeActivated(face, pipe, player, hand);
            if (value != InteractionResult.PASS) {
                player.m_5661_(pipe.getConnectionMessage(face), true);
                level.m_46672_(pos, (Block)this);
            }
            return value;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult onShapeActivated(Direction face, ElementPipeBlockEntity pipe, Player player, InteractionHand hand) {
        if (face != null) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && stack.m_41720_() == ECItems.PIPE_PRIORITY) {
                return pipe.activatePriority(face, player, hand);
            }
            return pipe.activatePipe(face);
        }
        return InteractionResult.PASS;
    }

    @Override
    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity te = level.m_7702_(pos);
            if (te instanceof ElementPipeBlockEntity) {
                ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)te;
                if (ElementPipeBlock.isCovered(state)) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)pipe.getCoverState().m_60734_()));
                }
                pipe.dropAllPriorities();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    private static ElementPipeBlockEntity getBlockEntity(BlockGetter world, BlockPos pos) {
        return BlockEntityHelper.getBlockEntityAs(world, pos, ElementPipeBlockEntity.class).orElse(null);
    }

    public int getMaxTransferAmount() {
        return this.maxTransferAmount;
    }

    public static enum CoverType implements StringRepresentable
    {
        NONE("none"),
        FRAME("frame"),
        COVERED("covered");

        public static final Codec<CoverType> CODEC;
        private final String name;

        private CoverType(String name) {
            this.name = name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public static CoverType byName(String name) {
            for (CoverType bonusType : CoverType.values()) {
                if (!bonusType.name.equals(name)) continue;
                return bonusType;
            }
            return NONE;
        }

        static {
            CODEC = StringRepresentable.m_14350_(CoverType::values, CoverType::byName);
        }
    }
}

