/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.firefurnace;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import sirttas.elementalcraft.block.instrument.io.AbstractIOInstrumentBlockEntity;
import sirttas.elementalcraft.container.ContainerBlockEntityWrapper;
import sirttas.elementalcraft.container.IOContainer;
import sirttas.elementalcraft.recipe.instrument.io.FurnaceRecipeWrapper;

public abstract class AbstractFireFurnaceBlockEntity<T extends AbstractCookingRecipe>
extends AbstractIOInstrumentBlockEntity<AbstractFireFurnaceBlockEntity<T>, FurnaceRecipeWrapper<T>> {
    private float exp;
    private final RecipeType<T> furnaceRecipeType;
    private final IOContainer inventory;

    protected AbstractFireFurnaceBlockEntity(BlockEntityType<? extends AbstractFireFurnaceBlockEntity<T>> blockEntityType, BlockPos pos, BlockState state, RecipeType<T> recipeType, int transferSpeed, int maxRunes) {
        super(blockEntityType, pos, state, null, transferSpeed, maxRunes);
        this.furnaceRecipeType = recipeType;
        this.exp = 0.0f;
        this.inventory = new IOContainer(this::m_6596_);
    }

    @Override
    @Nonnull
    protected IItemHandler createHandler() {
        return new SidedInvWrapper((WorldlyContainer)this.inventory, null);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.exp = compound.m_128457_("experience");
    }

    @Override
    @Nonnull
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128350_("experience", this.exp);
    }

    @Override
    protected FurnaceRecipeWrapper<T> lookupRecipe() {
        return this.m_58904_().m_7465_().m_44015_(this.furnaceRecipeType, ContainerBlockEntityWrapper.from(this), this.m_58904_()).map(FurnaceRecipeWrapper::new).orElse(null);
    }

    @Override
    protected void renderProgressParticles() {
        Random rand = this.f_58857_.f_46441_;
        double x = (double)this.f_58858_.m_123341_() + (5.0 + rand.nextDouble() * 6.0) / 16.0;
        double y = (double)this.f_58858_.m_123342_() + 0.375;
        double z = (double)this.f_58858_.m_123343_() + (5.0 + rand.nextDouble() * 6.0) / 16.0;
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.5, z, 0.0, 0.0, 0.0);
    }

    @Override
    public void assemble() {
        super.assemble();
        this.addExperience(((FurnaceRecipeWrapper)this.recipe).getExperience());
    }

    public void dropExperience(Player player) {
        this.dropExperience(player.m_20182_());
    }

    public void dropExperience(Vec3 pos) {
        while (this.exp > 0.0f) {
            int j = ExperienceOrb.m_20782_((int)((int)this.exp));
            this.exp -= (float)j;
            this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, pos.m_7096_(), pos.m_7098_() + 0.5, pos.m_7094_() + 0.5, j));
        }
        this.exp = 0.0f;
    }

    public void addExperience(float exp) {
        this.exp += exp;
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }
}

