/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.inscriber;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlockEntity;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.item.ECItems;

public class InscriberBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    public static final String NAME = "inscriber";
    private static final VoxelShape BASE_1 = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape CONNECTION = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_PIPE_1 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0);
    private static final VoxelShape BACK_BASE_PIPE_1 = Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)3.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_2 = Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0);
    private static final VoxelShape BACK_BASE_PIPE_2 = Block.m_49796_((double)13.0, (double)4.0, (double)1.0, (double)15.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_3 = Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0);
    private static final VoxelShape BACK_BASE_PIPE_3 = Block.m_49796_((double)1.0, (double)4.0, (double)13.0, (double)3.0, (double)5.0, (double)15.0);
    private static final VoxelShape BASE_PIPE_4 = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0);
    private static final VoxelShape BACK_BASE_PIPE_4 = Block.m_49796_((double)13.0, (double)4.0, (double)13.0, (double)15.0, (double)5.0, (double)15.0);
    private static final VoxelShape BASE_SHAPE = Shapes.m_83124_((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{CONNECTION, BASE_PIPE_1, BASE_PIPE_2, BASE_PIPE_3, BASE_PIPE_4});
    private static final VoxelShape BACK_BASE_NORTH = Block.m_49796_((double)0.0, (double)3.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_NORTH = Block.m_49796_((double)4.0, (double)2.0, (double)13.0, (double)6.0, (double)15.0, (double)15.0);
    private static final VoxelShape BACK_PIPE_2_NORTH = Block.m_49796_((double)10.0, (double)2.0, (double)13.0, (double)12.0, (double)15.0, (double)15.0);
    private static final VoxelShape BACK_NORTH = Shapes.m_83124_((VoxelShape)BACK_BASE_NORTH, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_3, BACK_BASE_PIPE_4, BACK_PIPE_1_NORTH, BACK_PIPE_2_NORTH});
    private static final VoxelShape PLATE_1_NORTH = Block.m_49796_((double)1.0, (double)2.0, (double)8.0, (double)15.0, (double)5.0, (double)11.0);
    private static final VoxelShape PLATE_2_NORTH = Block.m_49796_((double)1.0, (double)5.0, (double)9.0, (double)15.0, (double)8.0, (double)12.0);
    private static final VoxelShape PLATE_3_NORTH = Block.m_49796_((double)1.0, (double)8.0, (double)10.0, (double)15.0, (double)11.0, (double)13.0);
    private static final VoxelShape PLATE_4_NORTH = Block.m_49796_((double)1.0, (double)11.0, (double)11.0, (double)15.0, (double)14.0, (double)14.0);
    private static final VoxelShape PLATE_5_NORTH = Block.m_49796_((double)1.0, (double)14.0, (double)12.0, (double)15.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_NORTH = Shapes.m_83124_((VoxelShape)PLATE_1_NORTH, (VoxelShape[])new VoxelShape[]{PLATE_2_NORTH, PLATE_3_NORTH, PLATE_4_NORTH, PLATE_5_NORTH});
    private static final VoxelShape BACK_BASE_SOUTH = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0);
    private static final VoxelShape BACK_PIPE_1_SOUTH = Block.m_49796_((double)4.0, (double)2.0, (double)1.0, (double)6.0, (double)15.0, (double)3.0);
    private static final VoxelShape BACK_PIPE_2_SOUTH = Block.m_49796_((double)10.0, (double)2.0, (double)1.0, (double)12.0, (double)15.0, (double)3.0);
    private static final VoxelShape BACK_SOUTH = Shapes.m_83124_((VoxelShape)BACK_BASE_SOUTH, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_1, BACK_BASE_PIPE_2, BACK_PIPE_1_SOUTH, BACK_PIPE_2_SOUTH});
    private static final VoxelShape PLATE_1_SOUTH = Block.m_49796_((double)1.0, (double)2.0, (double)5.0, (double)15.0, (double)5.0, (double)8.0);
    private static final VoxelShape PLATE_2_SOUTH = Block.m_49796_((double)1.0, (double)5.0, (double)4.0, (double)15.0, (double)8.0, (double)7.0);
    private static final VoxelShape PLATE_3_SOUTH = Block.m_49796_((double)1.0, (double)8.0, (double)3.0, (double)15.0, (double)11.0, (double)6.0);
    private static final VoxelShape PLATE_4_SOUTH = Block.m_49796_((double)1.0, (double)11.0, (double)2.0, (double)15.0, (double)14.0, (double)5.0);
    private static final VoxelShape PLATE_5_SOUTH = Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)17.0, (double)4.0);
    private static final VoxelShape PLATE_SOUTH = Shapes.m_83124_((VoxelShape)PLATE_1_SOUTH, (VoxelShape[])new VoxelShape[]{PLATE_2_SOUTH, PLATE_3_SOUTH, PLATE_4_SOUTH, PLATE_5_SOUTH});
    private static final VoxelShape BACK_BASE_WEST = Block.m_49796_((double)12.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_WEST = Block.m_49796_((double)13.0, (double)2.0, (double)4.0, (double)15.0, (double)15.0, (double)6.0);
    private static final VoxelShape BACK_PIPE_2_WEST = Block.m_49796_((double)13.0, (double)2.0, (double)10.0, (double)15.0, (double)15.0, (double)12.0);
    private static final VoxelShape BACK_WEST = Shapes.m_83124_((VoxelShape)BACK_BASE_WEST, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_2, BACK_BASE_PIPE_4, BACK_PIPE_1_WEST, BACK_PIPE_2_WEST});
    private static final VoxelShape PLATE_1_WEST = Block.m_49796_((double)8.0, (double)2.0, (double)1.0, (double)11.0, (double)5.0, (double)15.0);
    private static final VoxelShape PLATE_2_WEST = Block.m_49796_((double)9.0, (double)5.0, (double)1.0, (double)12.0, (double)8.0, (double)15.0);
    private static final VoxelShape PLATE_3_WEST = Block.m_49796_((double)10.0, (double)8.0, (double)1.0, (double)13.0, (double)11.0, (double)15.0);
    private static final VoxelShape PLATE_4_WEST = Block.m_49796_((double)11.0, (double)11.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0);
    private static final VoxelShape PLATE_5_WEST = Block.m_49796_((double)12.0, (double)14.0, (double)1.0, (double)15.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_WEST = Shapes.m_83124_((VoxelShape)PLATE_1_WEST, (VoxelShape[])new VoxelShape[]{PLATE_2_WEST, PLATE_3_WEST, PLATE_4_WEST, PLATE_5_WEST});
    private static final VoxelShape BACK_BASE_EAST = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_EAST = Block.m_49796_((double)1.0, (double)2.0, (double)4.0, (double)3.0, (double)15.0, (double)6.0);
    private static final VoxelShape BACK_PIPE_2_EAST = Block.m_49796_((double)1.0, (double)2.0, (double)10.0, (double)3.0, (double)15.0, (double)12.0);
    private static final VoxelShape BACK_EAST = Shapes.m_83124_((VoxelShape)BACK_BASE_EAST, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_1, BACK_BASE_PIPE_3, BACK_PIPE_1_EAST, BACK_PIPE_2_EAST});
    private static final VoxelShape PLATE_1_EAST = Block.m_49796_((double)5.0, (double)2.0, (double)1.0, (double)8.0, (double)5.0, (double)15.0);
    private static final VoxelShape PLATE_2_EAST = Block.m_49796_((double)4.0, (double)5.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0);
    private static final VoxelShape PLATE_3_EAST = Block.m_49796_((double)3.0, (double)6.0, (double)1.0, (double)6.0, (double)8.0, (double)15.0);
    private static final VoxelShape PLATE_4_EAST = Block.m_49796_((double)2.0, (double)11.0, (double)1.0, (double)5.0, (double)14.0, (double)15.0);
    private static final VoxelShape PLATE_5_EAST = Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)4.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_EAST = Shapes.m_83124_((VoxelShape)PLATE_1_EAST, (VoxelShape[])new VoxelShape[]{PLATE_2_EAST, PLATE_3_EAST, PLATE_4_EAST, PLATE_5_EAST});
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_NORTH, PLATE_NORTH});
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_SOUTH, PLATE_SOUTH});
    private static final VoxelShape WEST_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_WEST, PLATE_WEST});
    private static final VoxelShape EAST_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_EAST, PLATE_EAST});
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public InscriberBlock() {
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new InscriberBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return this.createInstrumentTicker(level, type, InscriberBlockEntity.TYPE);
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        InscriberBlockEntity inscriber = (InscriberBlockEntity)world.m_7702_(pos);
        ItemStack heldItem = player.m_21120_(hand);
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)world, pos, null);
        if (!(inscriber == null || hand != InteractionHand.MAIN_HAND && heldItem.m_41619_())) {
            if (heldItem.m_41720_() == ECItems.CHISEL && !inscriber.isLocked()) {
                return this.makeProgress(player, hand, inscriber, heldItem);
            }
            if ((inscriber.isLocked() || heldItem.m_41619_() || player.m_6144_()) && !inscriber.getInventory().m_7983_()) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.onSlotActivated(inv, player, ItemStack.f_41583_, i);
                }
                return InteractionResult.SUCCESS;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!inv.getStackInSlot(i).m_41619_() || !this.onSlotActivated(inv, player, heldItem, i).m_19080_()) continue;
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private InteractionResult makeProgress(Player player, InteractionHand hand, InscriberBlockEntity inscriber, ItemStack heldItem) {
        if (inscriber.useChisle()) {
            if (heldItem.m_41763_() && !player.m_7500_()) {
                heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> BASE_SHAPE;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    @Nonnull
    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING});
    }

    @Deprecated
    public boolean m_7898_(BlockState state, @Nonnull LevelReader world, BlockPos pos) {
        return BlockEntityHelper.isValidContainer(state, world, pos.m_7495_());
    }

    @Nonnull
    @Deprecated
    public FluidState m_5888_(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }
}

