/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.crystallizer;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlock;
import sirttas.elementalcraft.block.instrument.AbstractInstrumentBlockEntity;
import sirttas.elementalcraft.block.instrument.InstrumentContainer;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerContainer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.elemental.ShardItem;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;

public class CrystallizerBlockEntity
extends AbstractInstrumentBlockEntity<CrystallizerBlockEntity, CrystallizationRecipe> {
    @ObjectHolder(value="elementalcraft:crystallizer")
    public static final BlockEntityType<CrystallizerBlockEntity> TYPE = null;
    private final InstrumentContainer inventory = new CrystallizerContainer(this::m_6596_);

    public CrystallizerBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state, CrystallizationRecipe.TYPE, (Integer)ECConfig.COMMON.crystallizerTransferSpeed.get(), (Integer)ECConfig.COMMON.crystallizerMaxRunes.get());
        this.lockable = true;
        this.particleOffset = new Vec3(0.0, 0.2, 0.0);
    }

    public int getItemCount() {
        return this.inventory.getItemCount();
    }

    @Override
    public void assemble() {
        int luck = (int)Math.round((double)this.getRuneHandler().getBonus(Rune.BonusType.LUCK) * (Double)ECConfig.COMMON.crystallizerLuckRatio.get());
        for (int i = 2; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (EvaporatorBlock.getShardElementType(stack) != ((CrystallizationRecipe)this.recipe).getElementType()) continue;
            luck += ((ShardItem)stack.m_41720_()).getElementAmount();
        }
        ItemStack gem = this.inventory.m_8020_(0);
        this.m_6211_();
        this.inventory.m_6836_(0, ((CrystallizationRecipe)this.recipe).assemble(gem, this, luck));
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }
}

