/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.crystallizer;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.container.ECContainerHelper;

public class CrystallizerBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    public static final String NAME = "crystallizer";
    private static final VoxelShape BASE_1 = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape CONNECTION = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_PIPE_1 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_2 = Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_3 = Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)5.0, (double)15.0);
    private static final VoxelShape BASE_PIPE_4 = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)5.0, (double)15.0);
    private static final VoxelShape TOP_1 = Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape TOP_2 = Block.m_49796_((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private static final VoxelShape HOLE_1 = Block.m_49796_((double)6.0, (double)3.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0);
    private static final VoxelShape HOLE_2 = Block.m_49796_((double)4.0, (double)3.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0);
    private static final VoxelShape TOP = Shapes.m_83113_((VoxelShape)Shapes.m_83110_((VoxelShape)TOP_1, (VoxelShape)TOP_2), (VoxelShape)Shapes.m_83110_((VoxelShape)HOLE_1, (VoxelShape)HOLE_2), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{CONNECTION, BASE_PIPE_1, BASE_PIPE_2, BASE_PIPE_3, BASE_PIPE_4, TOP});

    public CrystallizerBlock() {
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CrystallizerBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return this.createInstrumentTicker(level, type, CrystallizerBlockEntity.TYPE);
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        CrystallizerBlockEntity crystallizer = (CrystallizerBlockEntity)world.m_7702_(pos);
        ItemStack heldItem = player.m_21120_(hand);
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)world, pos, null);
        if (!(crystallizer == null || hand != InteractionHand.MAIN_HAND && heldItem.m_41619_())) {
            if ((crystallizer.isLocked() || heldItem.m_41619_() || player.m_6144_()) && !crystallizer.getInventory().m_7983_()) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.onSlotActivated(inv, player, ItemStack.f_41583_, i);
                }
                return InteractionResult.SUCCESS;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!inv.getStackInSlot(i).m_41619_() || !this.onSlotActivated(inv, player, heldItem, i).m_19080_()) continue;
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Deprecated
    public boolean m_7898_(BlockState state, @Nonnull LevelReader world, BlockPos pos) {
        return BlockEntityHelper.isValidContainer(state, world, pos.m_7495_());
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nonnull
    @Deprecated
    public FluidState m_5888_(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }
}

