/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.instrument.IInstrument;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;

public abstract class AbstractInstrumentBlockEntity<T extends IInstrument, R extends IInstrumentRecipe<T>>
extends AbstractECCraftingBlockEntity<T, R>
implements IInstrument {
    private int progress = 0;
    private final RuneHandler runeHandler;
    protected boolean lockable = false;
    private boolean locked = false;
    protected Vec3 particleOffset;

    protected AbstractInstrumentBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, RecipeType<R> recipeType, int transferSpeed, int maxRunes) {
        super(blockEntityType, pos, state, recipeType, transferSpeed);
        this.runeHandler = maxRunes > 0 ? new RuneHandler(maxRunes, this::m_6596_) : null;
        this.particleOffset = Vec3.f_82478_;
    }

    @Override
    public void process() {
        super.process();
        this.updateLock();
        if (this.f_58857_.f_46443_) {
            ParticleHelper.createCraftingParticle(this.getElementType(), this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_).m_82549_(this.particleOffset), this.f_58857_.f_46441_);
        }
    }

    public static <T extends IInstrument, R extends IInstrumentRecipe<T>> void tick(Level level, BlockPos pos, BlockState state, AbstractInstrumentBlockEntity<T, R> instrument) {
        if (!instrument.isPowered() && instrument.progressOnTick()) {
            instrument.makeProgress();
        }
        if (instrument.shouldRetrieverExtractOutput()) {
            RetrieverBlock.sendOutputToRetriever(level, instrument.f_58858_, instrument.getInventory(), instrument.outputSlot);
        }
        if (instrument.locked) {
            instrument.updateLock();
        }
    }

    protected boolean shouldRetrieverExtractOutput() {
        return !this.lockable || this.locked;
    }

    private void updateLock() {
        if (this.lockable) {
            this.locked = !this.getInventory().m_8020_(this.outputSlot).m_41619_();
        }
    }

    public boolean isLocked() {
        return this.lockable && this.locked;
    }

    protected boolean progressOnTick() {
        return true;
    }

    protected boolean makeProgress() {
        ISingleElementStorage container = this.getContainer();
        if (this.recipe != null && this.progress >= ((IInstrumentRecipe)this.recipe).getElementAmount()) {
            this.process();
            this.progress = 0;
            return true;
        }
        if (this.isRecipeAvailable() && container != null) {
            float preservation = this.runeHandler.getElementPreservation();
            int oldProgress = this.progress;
            this.progress = (int)((float)this.progress + (float)container.extractElement(Math.min(Math.round(this.runeHandler.getTransferSpeed(this.transferSpeed) / preservation), container.getElementAmount() - 1), this.getRecipeElementType(), false) * preservation);
            if (this.f_58857_.f_46443_ && this.progress > 0 && this.getProgressRounded(this.transferSpeed, this.progress) > this.getProgressRounded(this.transferSpeed, oldProgress)) {
                ParticleHelper.createElementFlowParticle(this.getElementType(), this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_).m_82549_(this.particleOffset), Direction.UP, 1.0f, this.f_58857_.f_46441_);
                this.renderProgressParticles();
            }
            return true;
        }
        if (this.recipe == null) {
            this.progress = 0;
        }
        return false;
    }

    protected void renderProgressParticles() {
    }

    private ElementType getRecipeElementType() {
        if (this.recipe != null) {
            return ((IInstrumentRecipe)this.recipe).getElementType();
        }
        return ElementType.NONE;
    }

    @Override
    protected void assemble() {
        this.getInventory().m_6836_(0, ((IInstrumentRecipe)this.recipe).assemble(this));
    }

    @Override
    public ElementType getElementType() {
        ElementType tankType = this.getContainerElementType();
        return tankType != ElementType.NONE || this.recipe == null ? tankType : this.getRecipeElementType();
    }

    @Override
    public boolean isRunning() {
        return this.progress > 0;
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("progress", this.progress);
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.progress = compound.m_128451_("progress");
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
    }

    @Override
    public void m_6211_() {
        super.m_6211_();
        this.progress = 0;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public float getProgressRatio() {
        return (float)this.progress / (float)((IInstrumentRecipe)this.recipe).getElementAmount();
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

