/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity.renderer;

import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.container.ContainerRenderer;
import sirttas.elementalcraft.block.container.ElementContainerBlockEntity;
import sirttas.elementalcraft.block.container.creative.CreativeElementContainerBlockEntity;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlockEntity;
import sirttas.elementalcraft.block.diffuser.DiffuserBlockEntity;
import sirttas.elementalcraft.block.diffuser.DiffuserRenderer;
import sirttas.elementalcraft.block.entity.renderer.RuneRenderer;
import sirttas.elementalcraft.block.entity.renderer.SingleItemRenderer;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlockEntity;
import sirttas.elementalcraft.block.extractor.ExtractorBlockEntity;
import sirttas.elementalcraft.block.instrument.binder.BinderBlockEntity;
import sirttas.elementalcraft.block.instrument.binder.BinderRenderer;
import sirttas.elementalcraft.block.instrument.binder.improved.ImprovedBinderBlockEntity;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerRenderer;
import sirttas.elementalcraft.block.instrument.infuser.InfuserBlockEntity;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlockEntity;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberRenderer;
import sirttas.elementalcraft.block.instrument.io.firefurnace.FireFurnaceBlockEntity;
import sirttas.elementalcraft.block.instrument.io.firefurnace.FireFurnaceRenderer;
import sirttas.elementalcraft.block.instrument.io.firefurnace.blast.FireBlastFurnaceBlockEntity;
import sirttas.elementalcraft.block.instrument.io.mill.AirMillBlockEntity;
import sirttas.elementalcraft.block.instrument.io.mill.AirMillRenderer;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlockEntity;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierRenderer;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeRenderer;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserRenderer;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlockEntity;
import sirttas.elementalcraft.block.shrine.ShrineRenderer;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.firepylon.FirePylonBlockEntity;
import sirttas.elementalcraft.block.shrine.grove.GroveShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.growth.GrowthShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.harvest.HarvestShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.lava.LavaShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.ore.OreShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.overload.OverloadShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.spawning.SpawningShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.spring.SpringShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.sweet.SweetShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.directional.acceleration.AccelerationShrineUpgradeBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.directional.acceleration.AccelerationShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.vortex.VortexShrineUpgradeBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.vortex.VortexShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.vacuum.VacuumShrineBlockEntity;
import sirttas.elementalcraft.block.sorter.SorterBlockEntity;
import sirttas.elementalcraft.block.sorter.SorterRenderer;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.block.source.SourceRenderer;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerRenderer;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.botania.BotaniaInteractions;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ECRenderers {
    private ECRenderers() {
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent evt) {
        ECRenderers.register(ElementPipeBlockEntity.TYPE, ElementPipeRenderer::new);
        ECRenderers.register(InfuserBlockEntity.TYPE, () -> new SingleItemRenderer(new Vec3(0.5, 0.2, 0.5)));
        ECRenderers.register(ExtractorBlockEntity.TYPE, RuneRenderer::create);
        ECRenderers.register(EvaporatorBlockEntity.TYPE, () -> new SingleItemRenderer(new Vec3(0.5, 0.2, 0.5), 0.5f));
        ECRenderers.register(SolarSynthesizerBlockEntity.TYPE, SolarSynthesizerRenderer::new);
        ECRenderers.register(DiffuserBlockEntity.TYPE, DiffuserRenderer::new);
        ECRenderers.register(BinderBlockEntity.TYPE, BinderRenderer::new);
        ECRenderers.register(ImprovedBinderBlockEntity.TYPE, BinderRenderer::new);
        ECRenderers.register(CrystallizerBlockEntity.TYPE, CrystallizerRenderer::new);
        ECRenderers.register(InscriberBlockEntity.TYPE, InscriberRenderer::new);
        ECRenderers.register(AirMillBlockEntity.TYPE, AirMillRenderer::new);
        ECRenderers.register(PedestalBlockEntity.TYPE, () -> new SingleItemRenderer(new Vec3(0.5, 0.9, 0.5)));
        ECRenderers.register(PureInfuserBlockEntity.TYPE, PureInfuserRenderer::new);
        ECRenderers.register(FireFurnaceBlockEntity.TYPE, FireFurnaceRenderer::new);
        ECRenderers.register(FireBlastFurnaceBlockEntity.TYPE, FireFurnaceRenderer::new);
        ECRenderers.register(PurifierBlockEntity.TYPE, PurifierRenderer::new);
        ECRenderers.register(AccelerationShrineUpgradeBlockEntity.TYPE, AccelerationShrineUpgradeRenderer::new);
        ECRenderers.register(VortexShrineUpgradeBlockEntity.TYPE, VortexShrineUpgradeRenderer::new);
        ECRenderers.register(SorterBlockEntity.TYPE, SorterRenderer::new);
        ECRenderers.register(SourceBlockEntity.TYPE, SourceRenderer::new);
        ECRenderers.register(FirePylonBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(VacuumShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(GrowthShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(HarvestShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(LavaShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(OreShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(OverloadShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(SweetShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(EnderLockShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(BreedingShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(GroveShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(BuddingShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(SpringShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(SpawningShrineBlockEntity.TYPE, ShrineRenderer::new);
        ECRenderers.register(ElementContainerBlockEntity.TYPE, ContainerRenderer::new);
        ECRenderers.register(CreativeElementContainerBlockEntity.TYPE, ContainerRenderer::new);
        ECRenderers.register(ReservoirBlockEntity.TYPE, ContainerRenderer::new);
        if (ECinteractions.isBotaniaActive()) {
            BotaniaInteractions.registerModels();
        }
    }

    public static void initRenderLayouts() {
        ECRenderers.setRenderLayer(ECBlocks.SMALL_CONTAINER, RenderType.m_110463_());
        ECRenderers.setRenderLayer(ECBlocks.CONTAINER, RenderType.m_110463_());
        ECRenderers.setRenderLayer((Block)ECBlocks.FIRE_RESERVOIR, RenderType.m_110463_());
        ECRenderers.setRenderLayer((Block)ECBlocks.EARTH_RESERVOIR, RenderType.m_110463_());
        ECRenderers.setRenderLayer((Block)ECBlocks.WATER_RESERVOIR, RenderType.m_110463_());
        ECRenderers.setRenderLayer((Block)ECBlocks.AIR_RESERVOIR, RenderType.m_110463_());
        ECRenderers.setRenderLayer((Block)ECBlocks.CREATIVE_CONTAINER, RenderType.m_110463_());
        ECRenderers.setRenderLayer((Block)ECBlocks.EVAPORATOR, RenderType.m_110463_());
        ECRenderers.setRenderLayer(ECBlocks.SMALL_SPRINGALINE_BUD, RenderType.m_110463_());
        ECRenderers.setRenderLayer(ECBlocks.MEDIUM_SPRINGALINE_BUD, RenderType.m_110463_());
        ECRenderers.setRenderLayer(ECBlocks.LARGE_SPRINGALINE_BUD, RenderType.m_110463_());
        ECRenderers.setRenderLayer(ECBlocks.SPRINGALINE_CLUSTER, RenderType.m_110463_());
        ECRenderers.setRenderLayer((Block)ECBlocks.SPAWNING_SHRINE, RenderType.m_110463_());
        ECRenderers.setRenderLayer((Block)ECBlocks.FIRE_BLAST_FURNACE, RenderType.m_110466_());
        ECRenderers.setRenderLayer((Block)ECBlocks.BURNT_GLASS, RenderType.m_110466_());
        ECRenderers.setRenderLayer((Block)ECBlocks.BURNT_GLASS_PANE, RenderType.m_110466_());
        ECRenderers.setRenderLayer(ECBlocks.SPRINGALINE_GLASS, RenderType.m_110466_());
        ECRenderers.setRenderLayer(ECBlocks.SPRINGALINE_GLASS_PANE, RenderType.m_110466_());
        ECRenderers.setRenderLayer(ECBlocks.SOURCE, RenderType.m_110466_());
        ECRenderers.setRenderLayer(ECBlocks.CAPACITY_SHRINE_UPGRADE, RenderType.m_110466_());
        ECRenderers.setRenderLayer(ECBlocks.OPTIMIZATION_SHRINE_UPGRADE, RenderType.m_110466_());
    }

    public static <T extends BlockEntity> void register(RegistryObject<BlockEntityType<T>> type, Supplier<BlockEntityRenderer<? super T>> renderProvider) {
        ECRenderers.register((BlockEntityType)type.get(), renderProvider);
    }

    public static <T extends BlockEntity> void register(BlockEntityType<T> type, Supplier<BlockEntityRenderer<? super T>> renderProvider) {
        BlockEntityRenderers.m_173590_(type, d -> (BlockEntityRenderer)renderProvider.get());
    }

    public static void setRenderLayer(RegistryObject<Block> block, RenderType type) {
        ECRenderers.setRenderLayer((Block)block.get(), type);
    }

    public static void setRenderLayer(Block block, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
    }
}

