/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.EmptyRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.container.IElementContainer;
import sirttas.elementalcraft.tag.ECTags;

public class BlockEntityHelper {
    private BlockEntityHelper() {
    }

    public static Optional<BlockEntity> getBlockEntity(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return Optional.ofNullable(world.m_7702_(pos));
    }

    public static <T> Optional<T> getBlockEntityAs(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Class<T> clazz) {
        return BlockEntityHelper.getBlockEntity(world, pos).filter(clazz::isInstance).map(clazz::cast);
    }

    public static Optional<ISingleElementStorage> getElementContainer(@Nonnull BlockGetter world, @Nonnull BlockPos pos, boolean canUseSmall) {
        return BlockEntityHelper.getBlockEntityAs(world, pos, IElementContainer.class).filter(t -> !t.isSmall() || canUseSmall).map(IElementContainer::getElementStorage);
    }

    public static Optional<ISingleElementStorage> getElementContainer(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return BlockEntityHelper.getBlockEntityAs(world, pos, IElementContainer.class).filter(t -> !t.isSmall() || state.m_204336_(ECTags.Blocks.SMALL_CONTAINER_COMPATIBLES)).map(IElementContainer::getElementStorage);
    }

    public static boolean isValidContainer(BlockState state, LevelReader world, BlockPos pos) {
        return BlockEntityHelper.getElementContainer(state, (BlockGetter)world, pos).isPresent();
    }

    public static Optional<IElementStorage> getElementStorageAt(LevelReader world, BlockPos pos) {
        return BlockEntityHelper.getBlockEntity((BlockGetter)world, pos).flatMap(t -> CapabilityElementStorage.get((ICapabilityProvider)t).resolve());
    }

    @Nonnull
    public static IRuneHandler getRuneHandlerAt(LevelReader world, BlockPos pos) {
        return BlockEntityHelper.getBlockEntity((BlockGetter)world, pos).map(CapabilityRuneHandler::get).flatMap(LazyOptional::resolve).orElse(EmptyRuneHandler.INSTANCE);
    }
}

