/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;

public abstract class AbstractIERBlockEntity
extends AbstractECContainerBlockEntity {
    protected AbstractIERBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public abstract IElementStorage getElementStorage();

    public abstract IRuneHandler getRuneHandler();

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        IElementStorage elementStorage = this.getElementStorage();
        if (compound.m_128441_("element_storage") && elementStorage instanceof INBTSerializable) {
            ((INBTSerializable)elementStorage).deserializeNBT((Tag)compound.m_128469_("element_storage"));
        }
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.getRuneHandler(), compound.m_128437_("rune_handler", 8));
        }
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        IElementStorage elementStorage = this.getElementStorage();
        if (elementStorage instanceof INBTSerializable) {
            compound.m_128365_("element_storage", ((INBTSerializable)elementStorage).serializeNBT());
        }
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.getRuneHandler()));
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_) {
            if (cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
                IElementStorage elementStorage = this.getElementStorage();
                return LazyOptional.of((NonNullSupplier)(elementStorage != null ? () -> elementStorage : null)).cast();
            }
            if (cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
                IRuneHandler runeHandler = this.getRuneHandler();
                return LazyOptional.of((NonNullSupplier)(runeHandler != null ? () -> runeHandler : null)).cast();
            }
        }
        return super.getCapability(cap, side);
    }
}

