/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;
import sirttas.elementalcraft.block.entity.ICraftingBlockEntity;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.recipe.IContainerBlockEntityRecipe;

public abstract class AbstractECCraftingBlockEntity<T extends ICraftingBlockEntity, R extends IContainerBlockEntityRecipe<T>>
extends AbstractECContainerBlockEntity
implements ICraftingBlockEntity {
    protected final RecipeType<R> recipeType;
    protected final int transferSpeed;
    protected R recipe;
    protected int outputSlot = 0;

    protected AbstractECCraftingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, RecipeType<R> recipeType, int transferSpeed) {
        super(blockEntityType, pos, state);
        this.recipeType = recipeType;
        this.transferSpeed = transferSpeed;
    }

    @Override
    public boolean isRecipeAvailable() {
        if (this.recipe != null && this.recipe.matches((ICraftingBlockEntity)this.cast())) {
            return true;
        }
        if (!this.getInventory().m_7983_()) {
            this.recipe = this.lookupRecipe();
            if (this.recipe != null) {
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    @Override
    public void process() {
        if (!this.f_58857_.f_46443_) {
            this.assemble();
            RetrieverBlock.sendOutputToRetriever(this.f_58857_, this.f_58858_, this.getInventory(), this.outputSlot);
        }
        this.recipe = null;
        this.m_6596_();
    }

    protected int getProgressRounded(float transferAmount, float progress) {
        return Math.round(progress / (transferAmount * 3.0f));
    }

    protected abstract void assemble();

    protected R lookupRecipe() {
        return (R)this.lookupRecipe(this.m_58904_(), this.recipeType);
    }
}

