/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.container.IContainerBlockEntity;

public abstract class AbstractECContainerBlockEntity
extends AbstractECBlockEntity
implements Clearable,
IContainerBlockEntity,
ContainerListener {
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(this::createHandler);

    protected AbstractECContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_6211_();
        super.onDataPacket(net, packet);
    }

    @Nonnull
    protected IItemHandler createHandler() {
        return new InvWrapper(this.getInventory());
    }

    @Override
    public void m_6211_() {
        this.getInventory().m_6211_();
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        Container inv = this.getInventory();
        if (inv instanceof INBTSerializable) {
            INBTSerializable nbtInv = (INBTSerializable)inv;
            if (compound.m_128441_("inventory")) {
                nbtInv.deserializeNBT(compound.m_128423_("inventory"));
            }
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        Container inv = this.getInventory();
        if (inv instanceof INBTSerializable) {
            INBTSerializable nbtInv = (INBTSerializable)inv;
            compound.m_128365_("inventory", nbtInv.serializeNBT());
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getItemHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public void m_5757_(@Nonnull Container invBasic) {
        this.m_6596_();
    }
}

