/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.registry.RegistryHelper;

public abstract class AbstractECBlockEntity
extends BlockEntity {
    private boolean dirty = true;

    protected AbstractECBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public void m_6596_() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isPowered() {
        return this.m_58898_() && this.m_58904_().m_46753_(this.m_58899_());
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    @Nonnull
    public final CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void sendUpdate() {
        if (this.isDirty()) {
            super.m_6596_();
            this.sendUpdatePacket();
            this.dirty = false;
        }
    }

    private void sendUpdatePacket() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.TRACKING_CHUNK.with(() -> serverLevel.m_46745_(this.f_58858_)).send((Packet)this.getUpdatePacket());
        }
    }

    protected static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> type(String name) {
        return RegistryHelper.object(name, ForgeRegistries.BLOCK_ENTITIES);
    }
}

